/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.shared.Registration;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.ItemCaptionGenerator;
import io.mateu.mdd.vaadin.components.fieldBuilders.components.WeekDaysComponent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeekDaysGridEditor
extends Composite
implements HasValue<String> {
    private static final Logger log = LoggerFactory.getLogger(WeekDaysGridEditor.class);
    List<String> days = Lists.newArrayList((Object[])new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"});
    CheckBoxGroup<String> g = new CheckBoxGroup("", this.days);
    final boolean[] array = new boolean[]{false, false, false, false, false, false, false};
    Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();

    public WeekDaysGridEditor() {
        this.g.addStyleName("horizontal");
        this.g.addStyleName("weekdaysinlineeditor");
        this.g.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)s -> "");
        this.g.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isUserOriginated()) {
                for (int i = 0; i < this.array.length; ++i) {
                    this.array[i] = ((Set)e.getValue()).contains(this.days.get(i));
                }
                HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent(this.g, this.g, e.isUserOriginated());
                this.listeners.values().forEach(l -> l.valueChange(ce));
            }
        });
        this.setCompositionRoot((Component)this.g);
    }

    public void setValue(String o) {
        int i;
        log.debug("setValue(" + o + ")");
        for (i = 0; i < this.array.length; ++i) {
            this.array[i] = false;
        }
        if (o != null) {
            for (i = 0; i < this.days.size(); ++i) {
                if (i >= this.array.length) continue;
                this.array[i] = o.contains(this.days.get(i));
            }
        }
        HashSet<String> values = new HashSet<String>();
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (!this.array[i2]) continue;
            values.add(this.days.get(i2));
        }
        this.g.setValue(values);
    }

    public String getValue() {
        log.debug("getValue()");
        String s = "";
        for (int i = 0; i < this.array.length; ++i) {
            if (!"".equals(s)) {
                s = s + ",";
            }
            s = s + (this.array[i] ? WeekDaysComponent.days.get(i) : "-");
        }
        return s;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<String> valueChangeListener) {
        log.debug("addValueChangeListener(" + valueChangeListener + ")");
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                WeekDaysGridEditor.this.listeners.remove(this.id);
            }
        };
    }

    public void setRequiredIndicatorVisible(boolean b) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setReadOnly(boolean b) {
    }

    public boolean isReadOnly() {
        return false;
    }
}

