/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Button;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.interfaces.WizardPage;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardComponent
extends EditorViewComponent {
    private static final Logger log = LoggerFactory.getLogger(WizardComponent.class);
    private List<WizardPage> stack = new ArrayList<WizardPage>();
    private WizardPage currentPage = null;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.ELLIPSIS_DOTS_H;
    }

    public WizardComponent(WizardPage page) {
        super(page.getClass());
        this.setPage(page);
    }

    @Override
    public List<AbstractAction> getActions() {
        ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
        l.add(new MDDRunnableAction("Prev"){

            public void addShortCut(Button b) {
                b.setClickShortcut(37, new int[]{17, 18});
            }

            public void run() {
                WizardPage prevPage = (WizardPage)WizardComponent.this.stack.remove(0);
                WizardComponent.this.currentPage = null;
                try {
                    WizardComponent.this.setPage(prevPage);
                }
                catch (Exception e1) {
                    Notifier.alert((Throwable)e1);
                }
            }

            public boolean isVisible() {
                return WizardComponent.this.stack.size() > 0;
            }
        }.setIcon(VaadinIcons.STEP_BACKWARD).setId("wizardprev"));
        l.add(new MDDRunnableAction("Next"){

            public void addShortCut(Button b) {
                b.setClickShortcut(39, new int[]{17, 18});
            }

            public void run() {
                if (WizardComponent.this.validate()) {
                    WizardPage nextPage = WizardComponent.this.currentPage.getNext();
                    try {
                        WizardComponent.this.setPage(nextPage);
                    }
                    catch (Exception e1) {
                        Notifier.alert((Throwable)e1);
                    }
                }
            }

            public boolean isVisible() {
                return WizardComponent.this.currentPage.hasNext();
            }
        }.setIcon(VaadinIcons.STEP_FORWARD).setId("wizardnext"));
        l.add(new MDDRunnableAction(this.currentPage.getOkCaption()){

            public void addShortCut(Button b) {
                b.setClickShortcut(13, new int[]{17, 18});
            }

            public void run() {
                if (WizardComponent.this.validate()) {
                    try {
                        WizardComponent.this.currentPage.onOk();
                        if (WizardComponent.this.currentPage.backOnOk()) {
                            MDDUIAccessor.goBack();
                        }
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            }

            public boolean isVisible() {
                return !WizardComponent.this.currentPage.hasNext();
            }
        }.setIcon(VaadinIcons.CHECK).setId("wizarddone"));
        l.add(new MDDRunnableAction(this.currentPage.getOkAndStayCaption()){

            public void addShortCut(Button b) {
                b.setClickShortcut(13, new int[]{17});
            }

            public void run() {
                if (WizardComponent.this.validate()) {
                    try {
                        WizardComponent.this.currentPage.onOk();
                        Notifier.info((String)"Done");
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            }

            public boolean isVisible() {
                return !WizardComponent.this.currentPage.hasNext() && WizardComponent.this.currentPage.backOnOk();
            }
        }.setIcon(VaadinIcons.CHECK_CIRCLE).setId("wizarddonealt"));
        l.addAll(super.getActions());
        return l;
    }

    private void setPage(WizardPage page) {
        if (this.currentPage != null) {
            this.stack.add(0, this.currentPage);
        }
        this.currentPage = page;
        this.setModel(page);
        MDDUIAccessor.updateTitle((String)Helper.capitalize((String)this.currentPage.getClass().getSimpleName()));
    }

    @Override
    public String toString() {
        return Helper.capitalize((String)this.currentPage.getClass().getSimpleName());
    }
}

