/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/tmp/*"}, loadOnStartup=10)
public class TmpContentServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(TmpContentServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = System.getProperty("tmpdir", request.getServletContext().getRealPath("/tmp/"));
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File downloadFile = new File(path + request.getPathInfo());
        FileInputStream inStream = new FileInputStream(downloadFile);
        String relativePath = this.getServletContext().getRealPath("");
        log.debug("relativePath = " + relativePath);
        ServletContext context = this.getServletContext();
        String mimeType = context.getMimeType(downloadFile.getAbsolutePath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        log.debug("MIME type: " + mimeType);
        if ("text/html".equalsIgnoreCase(mimeType)) {
            response.setCharacterEncoding("utf-8");
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inStream.close();
        outStream.close();
    }
}

