/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import io.mateu.mdd.core.MDD;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.mdd.shared.FormLayoutBuilderParameters;
import io.mateu.mdd.shared.annotations.RightAlignedCol;
import io.mateu.mdd.shared.annotations.UseRadioButtons;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAOutputFieldBuilder;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.FormLayoutBuilder;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.BindedWindow;
import io.mateu.reflection.FieldInterfacedFromType;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.common.EmptyRow;
import io.mateu.util.data.Value;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javassist.ClassPool;
import javax.money.MonetaryAmount;
import javax.persistence.Query;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.javamoney.moneta.FastMoney;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinHelper {
    private static final Logger log = LoggerFactory.getLogger(VaadinHelper.class);

    public static void choose(String caption, final Set possibleValues, Consumer onOk, Runnable onClose) {
        FieldInterfacedFromType field = new FieldInterfacedFromType(Object.class, "value", (DataProvider)new ListDataProvider((Collection)possibleValues)){

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                if (UseRadioButtons.class.equals(annotationClass) && possibleValues.size() < 15) {
                    return true;
                }
                return super.isAnnotationPresent(annotationClass);
            }

            public boolean forceInput() {
                return true;
            }
        };
        ArrayList fields = Lists.newArrayList((Object[])new FieldInterfaced[]{field});
        MDDBinder binder = new MDDBinder(fields);
        Window subWindow = new Window(caption);
        VerticalLayout subContent = new VerticalLayout();
        subWindow.setContent((Component)subContent);
        VerticalLayout vl = new VerticalLayout();
        HashMap model = new HashMap();
        binder.setBean(model);
        HashMap validators = new HashMap();
        ArrayList<Component> componentsToLookForErrors = new ArrayList<Component>();
        FormLayoutBuilder.get().build((Layout)vl, binder, model.getClass(), model, componentsToLookForErrors, FormLayoutBuilderParameters.builder().validators(validators).allFields((List)fields).build(), null);
        subContent.addComponent((Component)vl);
        Button b = new Button("OK");
        subContent.addComponent((Component)b);
        Value okd = new Value((Object)false);
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            if (VaadinHelper.validate(componentsToLookForErrors)) {
                Object v = ((Map)binder.getBean()).get("value");
                onOk.accept(v);
                okd.set((Object)true);
                subWindow.close();
            }
        });
        subWindow.center();
        subWindow.setModal(true);
        subWindow.addCloseListener((Window.CloseListener & Serializable)e -> {
            if (!((Boolean)okd.get()).booleanValue()) {
                onClose.run();
            }
        });
        UI.getCurrent().addWindow(subWindow);
    }

    private static boolean validate(List<Component> componentsToLookForErrors) {
        boolean noerror = true;
        for (Component c : componentsToLookForErrors) {
            if (!(c instanceof AbstractComponent) || ((AbstractComponent)c).getComponentError() == null) continue;
            noerror = false;
            Notifier.alert((String)"Please solve errors for all fields");
            break;
        }
        return noerror;
    }

    public static <T> void getValue(String caption, Class<T> type, Consumer<T> f) {
        HashMap allFieldContainers = new HashMap();
        JPAOutputFieldBuilder ofb = new JPAOutputFieldBuilder();
        FieldInterfacedFromType field = new FieldInterfacedFromType(type, "value");
        ArrayList fields = Lists.newArrayList((Object[])new FieldInterfaced[]{field});
        MDDBinder binder = new MDDBinder(fields);
        Window subWindow = new Window(caption);
        VerticalLayout subContent = new VerticalLayout();
        subWindow.setContent((Component)subContent);
        VerticalLayout vl = new VerticalLayout();
        HashMap model = new HashMap();
        binder.setBean(model);
        HashMap validators = new HashMap();
        ArrayList<Component> componentsToLookForErrors = new ArrayList<Component>();
        FormLayoutBuilder.get().build((Layout)vl, binder, model.getClass(), model, componentsToLookForErrors, FormLayoutBuilderParameters.builder().validators(validators).allFields((List)fields).build(), null);
        subContent.addComponent((Component)vl);
        Button b = new Button("OK");
        subContent.addComponent((Component)b);
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            if (VaadinHelper.validate(componentsToLookForErrors)) {
                Object v = ((Map)binder.getBean()).get("value");
                f.accept(v);
                subWindow.close();
            }
        });
        subWindow.center();
        subWindow.setModal(true);
        UI.getCurrent().addWindow(subWindow);
    }

    public static <K, V> void getPair(String caption, Class<K> keyType, Class<V> valueType, BiConsumer<K, V> f) {
        HashMap allFieldContainers = new HashMap();
        JPAOutputFieldBuilder ofb = new JPAOutputFieldBuilder();
        FieldInterfacedFromType keyField = new FieldInterfacedFromType(keyType, "key");
        FieldInterfacedFromType valueField = new FieldInterfacedFromType(valueType, "value");
        ArrayList fields = Lists.newArrayList((Object[])new FieldInterfaced[]{keyField, valueField});
        MDDBinder binder = new MDDBinder(fields);
        Window subWindow = new Window(caption);
        VerticalLayout subContent = new VerticalLayout();
        subWindow.setContent((Component)subContent);
        VerticalLayout vl = new VerticalLayout();
        HashMap model = new HashMap();
        binder.setBean(model);
        HashMap validators = new HashMap();
        ArrayList<Component> componentsToLookForErrors = new ArrayList<Component>();
        FormLayoutBuilder.get().build((Layout)vl, binder, model.getClass(), model, componentsToLookForErrors, FormLayoutBuilderParameters.builder().validators(validators).allFields((List)fields).build(), null);
        subContent.addComponent((Component)vl);
        Button b = new Button("OK");
        subContent.addComponent((Component)b);
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            if (VaadinHelper.validate(componentsToLookForErrors)) {
                Map bean = (Map)binder.getBean();
                Object k = bean.get("key");
                Object v = bean.get("value");
                if (k != null) {
                    f.accept(k, v);
                    subWindow.close();
                } else {
                    Notifier.alert((String)"Key can not be empty");
                }
            }
        });
        subWindow.center();
        subWindow.setModal(true);
        UI.getCurrent().addWindow(subWindow);
    }

    public static void fill(String caption, Constructor c, Consumer onOk, Runnable onClose) {
        VaadinHelper.fill(null, caption, c, onOk, onClose);
    }

    public static void fill(EditorViewComponent evc, String caption, Constructor c, Consumer onOk, Runnable onClose) {
        try {
            Class pc = ReflectionHelper.createClass((ClassPool)MDD.getClassPool(), MDDBinder.class, (ClassLoader)MDD.getClassPool().getClassLoader(), (String)("" + c.getDeclaringClass().getSimpleName() + "_" + c.getName() + "_Parameters000"), (List)ReflectionHelper.getAllFields((Constructor)c), (boolean)false);
            List fields = ReflectionHelper.getAllFields((Class)pc);
            final MDDBinder binder = new MDDBinder(pc);
            BindedWindow subWindow = new BindedWindow(caption){

                @Override
                public MDDBinder getBinder() {
                    return binder;
                }
            };
            VerticalLayout subContent = new VerticalLayout();
            subWindow.setContent((Component)subContent);
            VerticalLayout vl = new VerticalLayout();
            Object model = pc.newInstance();
            binder.setBean(model);
            HashMap validators = new HashMap();
            ArrayList<Component> componentsToLookForErrors = new ArrayList<Component>();
            FormLayoutBuilder.get().build((Layout)vl, binder, model.getClass(), model, componentsToLookForErrors, FormLayoutBuilderParameters.builder().validators(validators).allFields(fields).build(), null);
            subContent.addComponent((Component)vl);
            Button b = new Button("OK");
            subContent.addComponent((Component)b);
            Value okd = new Value((Object)false);
            b.addClickListener((Button.ClickListener & Serializable)e -> {
                if (VaadinHelper.validate(componentsToLookForErrors)) {
                    Object v = null;
                    try {
                        v = ReflectionHelper.newInstance((Constructor)c, (Object)binder.getBean());
                        onOk.accept(v);
                        okd.set((Object)true);
                        subWindow.close();
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                }
            });
            subWindow.center();
            subWindow.setModal(true);
            subWindow.addCloseListener((Window.CloseListener & Serializable)e -> {
                if (evc != null) {
                    evc.setCreatorWindow(null);
                }
                if (!(subWindow.getData() != null && subWindow.getData() instanceof Boolean && !((Boolean)subWindow.getData()).booleanValue() || ((Boolean)okd.get()).booleanValue())) {
                    onClose.run();
                }
            });
            UI.getCurrent().addWindow((Window)subWindow);
            if (evc != null) {
                evc.setCreatorWindow(subWindow);
            }
        }
        catch (Exception e2) {
            Notifier.alert((Throwable)e2);
            onClose.run();
        }
    }

    public static URL viewToExcel(RpcView view, Object filters, List<QuerySortOrder> sortOrders) throws Throwable {
        return VaadinHelper.listToExcel(view.rpc(filters, sortOrders, 0, Integer.MAX_VALUE));
    }

    public static Object listViewComponentToExcel(ListViewComponent listViewComponent, Object filters) throws Throwable {
        return VaadinHelper.listToExcel(listViewComponent.findAll(filters, null, 0, Integer.MAX_VALUE), ListViewComponent.getColumnFields(listViewComponent.getColumnType()));
    }

    public static URL viewToPdf(RpcView view, Object filters, List<QuerySortOrder> sortOrders) throws Throwable {
        return VaadinHelper.listToPdf(view.rpc(filters, sortOrders, 0, Integer.MAX_VALUE));
    }

    public static Object listViewComponentToPdf(ListViewComponent listViewComponent, Object filters) throws Throwable {
        return VaadinHelper.listToPdf(listViewComponent.getTitle(), listViewComponent.findAll(filters, null, 0, Integer.MAX_VALUE), ListViewComponent.getColumnFields(listViewComponent.getColumnType()));
    }

    public static URL queryToPdf(Query query) throws Throwable {
        return VaadinHelper.listToPdf(query.getResultList());
    }

    public static URL listToPdf(Collection list) throws Throwable {
        return VaadinHelper.listToPdf(null, list, null);
    }

    public static URL listToPdf(String title, Collection list, List<FieldInterfaced> colFields) throws Throwable {
        String[] xslfo = new String[]{""};
        JPAHelper.notransact(em -> {
            xslfo[0] = ((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).get().getXslfoForList();
        });
        long t0 = new Date().getTime();
        try {
            String alto;
            Object ancho;
            int pixels;
            boolean xx;
            List<FieldInterfaced> rowFields;
            Class<EmptyRow> rowClass = list.size() > 0 ? list.iterator().next().getClass() : EmptyRow.class;
            Document xml = new Document();
            Element arrel = new Element("root");
            xml.addContent((Content)arrel);
            Element cab = new Element("header");
            arrel.addContent((Content)cab);
            if (!Strings.isNullOrEmpty((String)title)) {
                cab.addContent((Content)new Element("title").setText(title));
            }
            Element lineas = new Element("lines");
            arrel.addContent((Content)lineas);
            if (Object[].class.equals(rowClass)) {
                rowFields = colFields != null ? colFields : VaadinHelper.getColumnFields(rowClass);
                xx = true;
                pixels = 0;
                for (FieldInterfaced c : rowFields) {
                    Object alineado = "left";
                    Element aux = new Element("column");
                    cab.addContent((Content)aux);
                    aux.setAttribute("label", ReflectionHelper.getCaption((FieldInterfaced)c));
                    double ancho2 = ListViewComponent.getColumnWidth(c);
                    aux.setAttribute("width", "" + ancho2 / 1.5);
                    if (Integer.class.equals((Object)c.getType()) || Integer.TYPE.equals(c.getType()) || Long.class.equals((Object)c.getType()) || Long.TYPE.equals(c.getType()) || Double.class.equals((Object)c.getType()) || Double.TYPE.equals(c.getType()) || BigInteger.class.equals((Object)c.getType()) || BigDecimal.class.equals((Object)c.getType()) || Number.class.equals((Object)c.getType()) || FastMoney.class.equals((Object)c.getType()) || MonetaryAmount.class.equals((Object)c.getType()) || c.isAnnotationPresent(RightAlignedCol.class)) {
                        alineado = "right";
                    }
                    aux.setAttribute("align", (String)alineado);
                    pixels = (int)((double)pixels + ancho2);
                }
                ancho = "21cm";
                alto = "29.7cm";
                if (pixels > 750) {
                    alto = "21cm";
                    ancho = "29.7cm";
                }
                arrel.setAttribute("width", (String)ancho);
                arrel.setAttribute("height", alto);
                for (Object x : list) {
                    Element linea = new Element("line");
                    lineas.addContent((Content)linea);
                    int col = 1;
                    for (FieldInterfaced c : rowFields) {
                        Element cell = new Element("cell");
                        linea.addContent((Content)cell);
                        Object[] a = (Object[])x;
                        Object v = a.length > col ? a[col++] : null;
                        String text = "";
                        if (v != null) {
                            text = text + v;
                        }
                        if (v instanceof Double) {
                            DecimalFormat dfm = new DecimalFormat("#0.00");
                            text = dfm.format((Double)v);
                        }
                        cell.setText(text);
                    }
                }
            } else {
                rowFields = VaadinHelper.getColumnFields(rowClass);
                xx = true;
                pixels = 0;
                for (FieldInterfaced c : rowFields) {
                    String alineado = "left";
                    Element aux = new Element("column");
                    cab.addContent((Content)aux);
                    aux.setAttribute("label", ReflectionHelper.getCaption((FieldInterfaced)c));
                    double ancho3 = ListViewComponent.getColumnWidth(c);
                    aux.setAttribute("width", "" + ancho3 / 1.5);
                    if (Integer.class.equals((Object)c.getType()) || Integer.TYPE.equals(c.getType()) || Long.class.equals((Object)c.getType()) || Long.TYPE.equals(c.getType()) || Double.class.equals((Object)c.getType()) || Double.TYPE.equals(c.getType()) || BigInteger.class.equals((Object)c.getType()) || BigDecimal.class.equals((Object)c.getType()) || Number.class.equals((Object)c.getType()) || FastMoney.class.equals((Object)c.getType()) || MonetaryAmount.class.equals((Object)c.getType()) || c.isAnnotationPresent(RightAlignedCol.class)) {
                        alineado = "right";
                    }
                    aux.setAttribute("align", alineado);
                    pixels = (int)((double)pixels + ancho3);
                }
                ancho = "21cm";
                alto = "29.7cm";
                if (pixels > 750) {
                    alto = "21cm";
                    ancho = "29.7cm";
                }
                arrel.setAttribute("width", (String)ancho);
                arrel.setAttribute("height", alto);
                for (Object x : list) {
                    Element linea = new Element("line");
                    lineas.addContent((Content)linea);
                    for (FieldInterfaced c : rowFields) {
                        Element cell = new Element("cell");
                        linea.addContent((Content)cell);
                        Object v = ReflectionHelper.getValue((FieldInterfaced)c, x);
                        String text = "";
                        if (v != null) {
                            text = text + v;
                        }
                        if (v instanceof Double) {
                            DecimalFormat dfm = new DecimalFormat("#0.00");
                            text = dfm.format((Double)v);
                        }
                        cell.setText(text);
                    }
                }
            }
            if (list.size() >= 5000) {
                Element linea = new Element("line");
                lineas.addContent((Content)linea);
                Element txt = new Element("cell");
                linea.addContent((Content)txt);
                txt.setText("HAY MAS DE 5000 LINEAS. CONTACTA CON EL DEPARTAMENTO DE DESARROLLO SI QUIERES EL EXCEL COMPLETO...");
            }
            try {
                String archivo = UUID.randomUUID().toString();
                File temp = System.getProperty("tmpdir") == null ? File.createTempFile(archivo, ".pdf") : new File(new File(System.getProperty("tmpdir")), archivo + ".pdf");
                log.debug("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
                log.debug("Temp file : " + temp.getAbsolutePath());
                FileOutputStream fileOut = new FileOutputStream(temp);
                String sxml = new XMLOutputter(Format.getPrettyFormat()).outputString(xml);
                log.debug("xslfo=" + xslfo);
                log.debug("xml=" + sxml);
                fileOut.write(Helper.fop((Source)new StreamSource(new StringReader(xslfo[0])), (Source)new StreamSource(new StringReader(sxml))));
                fileOut.close();
                String baseUrl = System.getProperty("tmpurl");
                if (baseUrl == null) {
                    return temp.toURI().toURL();
                }
                return new URL(baseUrl + "/" + temp.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private static List<FieldInterfaced> getColumnFields(Class rowClass) {
        List<FieldInterfaced> cols = ListViewComponent.getColumnFields(rowClass);
        return cols;
    }

    public static URL queryToExcel(Query query) throws Throwable {
        return VaadinHelper.listToExcel(query.getResultList());
    }

    public static URL listToExcel(Collection list) throws Throwable {
        return VaadinHelper.listToExcel(list, null);
    }

    public static URL listToExcel(Collection list, List<FieldInterfaced> colFields) throws Throwable {
        long t0 = new Date().getTime();
        try {
            File temp = VaadinHelper.writeExcel(list, colFields);
            String baseUrl = System.getProperty("tmpurl");
            if (baseUrl == null) {
                return temp.toURI().toURL();
            }
            return new URL(baseUrl + "/" + temp.getName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static File writeExcel(Collection data, List<FieldInterfaced> colFields) throws IOException, InvalidFormatException {
        String archivo = UUID.randomUUID().toString();
        File temp = System.getProperty("tmpdir") == null ? File.createTempFile(archivo, ".xlsx") : new File(new File(System.getProperty("tmpdir")), archivo + ".xlsx");
        log.debug("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        log.debug("Temp file : " + temp.getAbsolutePath());
        XSSFWorkbook wb = new XSSFWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet();
        int posfila = 0;
        for (Object l2 : data) {
            Row row = sheet.createRow(posfila);
            for (int poscol = 0; poscol < colFields.size(); ++poscol) {
                Cell cell = row.createCell(poscol);
                Object v = null;
                try {
                    v = l2 instanceof Object[] ? ((Object[])l2)[poscol + 1] : ReflectionHelper.getValue((FieldInterfaced)colFields.get(poscol), l2);
                    Helper.fillCell((Workbook)wb, (CreationHelper)createHelper, (Cell)cell, (Object)v);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++posfila;
        }
        FileOutputStream fileOut = new FileOutputStream(temp);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        return temp;
    }

    public static void saveOrDiscard(String msg, EditorViewComponent editor, Runnable afterSave) {
        Window w = new Window("Please confirm action");
        VerticalLayout l = new VerticalLayout();
        l.addComponent((Component)new Label(msg));
        Component[] componentArray = new Component[3];
        Button buttonSaveBefore = new Button("Save and proceed", (Button.ClickListener & Serializable)e -> {
            try {
                if (editor.validate()) {
                    editor.save(false);
                    afterSave.run();
                }
            }
            catch (Throwable t) {
                Notifier.alert((Throwable)t);
            }
            w.close();
        });
        componentArray[0] = buttonSaveBefore;
        Button buttonYes = new Button("Exit and discard changes", (Button.ClickListener & Serializable)e -> {
            try {
                afterSave.run();
            }
            catch (Throwable t) {
                Notifier.alert((Throwable)t);
            }
            w.close();
        });
        componentArray[1] = buttonYes;
        Button buttonNo = new Button("Abort and stay here", (Button.ClickListener & Serializable)e -> w.close());
        componentArray[2] = buttonNo;
        HorizontalLayout hl = new HorizontalLayout(componentArray);
        l.addComponent((Component)hl);
        hl.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        buttonSaveBefore.addStyleName("friendly");
        buttonYes.addStyleName("danger");
        w.setContent((Component)l);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow(w);
    }

    public static void confirm(String msg, Runnable onOk) {
        Window w = new Window("Please confirm action");
        VerticalLayout l = new VerticalLayout();
        l.addComponent((Component)new Label(msg));
        Component[] componentArray = new Component[2];
        Button buttonYes = new Button("Yes, do it", (Button.ClickListener & Serializable)e -> {
            try {
                onOk.run();
            }
            catch (Throwable t) {
                Notifier.alert((Throwable)t);
            }
            w.close();
        });
        componentArray[0] = buttonYes;
        Button buttonNo = new Button("No, thanks", (Button.ClickListener & Serializable)e -> w.close());
        componentArray[1] = buttonNo;
        HorizontalLayout hl = new HorizontalLayout(componentArray);
        l.addComponent((Component)hl);
        hl.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        buttonNo.addStyleName("friendly");
        buttonYes.addStyleName("danger");
        w.setContent((Component)l);
        w.center();
        w.setModal(true);
        UI.getCurrent().addWindow(w);
    }
}

