/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.charts;

import com.byteowls.vaadin.chartjs.ChartJs;
import com.byteowls.vaadin.chartjs.config.ChartConfig;
import com.byteowls.vaadin.chartjs.config.PieChartConfig;
import com.byteowls.vaadin.chartjs.data.Dataset;
import com.byteowls.vaadin.chartjs.data.PieDataset;
import com.byteowls.vaadin.chartjs.options.InteractionMode;
import com.byteowls.vaadin.chartjs.options.types.PieChartOptions;
import com.google.common.base.Strings;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import io.mateu.mdd.vaadin.components.charts.ChartData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class PieChart
extends Composite {
    private static String[] colores = new String[]{"red", "blue", "green", "orange", "darkgrey", "cyan", "yellow", "brown"};
    private static Random randBGColor = new Random();
    private final String title;
    private ListDataProvider<ChartData> dataProvider;

    public PieChart(ListDataProvider<ChartData> dataProvider) {
        this(null, dataProvider);
    }

    public PieChart(String title, ListDataProvider<ChartData> dataProvider) {
        this.title = title;
        this.dataProvider = dataProvider;
        this.setCompositionRoot((Component)new ChartJs((ChartConfig)this.createConfig(title, dataProvider)));
        this.setWidth("100%");
    }

    private PieChartConfig createConfig(String title, ListDataProvider<ChartData> dataProvider) {
        HashMap data = new HashMap();
        ArrayList keys = new ArrayList();
        ArrayList labels = new ArrayList();
        HashMap dataSets = new HashMap();
        dataProvider.fetch(new Query()).forEach(r -> {
            HashMap<Object, Double> l = (HashMap<Object, Double>)data.get(r.getLine());
            if (l == null) {
                l = new HashMap<Object, Double>();
                data.put(r.getLine(), l);
            }
            l.put(r.getLabel(), r.getValue());
            if (!keys.contains(r.getLine())) {
                keys.add(r.getLine());
            }
            if (!labels.contains(r.getLabel())) {
                labels.add(r.getLabel());
            }
        });
        PieChartConfig barConfig = new PieChartConfig();
        barConfig.data().labelsAsList(labels.stream().map(l -> "" + l).collect(Collectors.toList()));
        keys.forEach(k -> dataSets.computeIfAbsent(k, l -> {
            PieDataset ds = new PieDataset();
            ds.label("" + l);
            ds.backgroundColor(colores);
            barConfig.data().addDataset((Dataset)ds);
            return ds;
        }));
        PieChartOptions options = barConfig.options();
        ((PieChartOptions)options.responsive(true)).hover().mode(InteractionMode.INDEX).intersect(true).animationDuration(400).and();
        if (!Strings.isNullOrEmpty((String)title)) {
            options.title().display(true).text(title).and();
        }
        options.done();
        for (Object k2 : keys) {
            PieDataset lds = (PieDataset)dataSets.get(k2);
            ArrayList<Double> dl = new ArrayList<Double>();
            for (Object l2 : labels) {
                dl.add(((Map)data.get(k2)).getOrDefault(l2, 0.0));
            }
            lds.dataAsList(dl);
        }
        return barConfig;
    }

    private String randomBGColor() {
        return colores[randBGColor.nextInt(colores.length)];
    }
}

