/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.vaadin.data.Result;
import com.vaadin.ui.DateTimeField;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class JPADateTimeField
extends DateTimeField {
    protected Result<LocalDateTime> handleUnparsableDateString(String dateString) {
        Result r = super.handleUnparsableDateString(dateString);
        if (r.isError()) {
            LocalDate date = null;
            if ("h".equalsIgnoreCase(dateString) || "t".equalsIgnoreCase(dateString)) {
                date = LocalDate.now();
            } else {
                String formatString = "dd/MM/yyyy";
                boolean lenient = true;
                DateTimeFormatter format = DateTimeFormatter.ofPattern(formatString);
                boolean inverso = false;
                String z = formatString.toLowerCase();
                if (z.indexOf("m") < z.indexOf("d")) {
                    inverso = true;
                }
                LocalDate h = LocalDate.now();
                h = h.minusDays(7L);
                if (dateString != null && !"".equals(dateString.trim())) {
                    if (dateString.contains("/") || dateString.contains("-")) {
                        date = LocalDate.parse(dateString, format);
                    } else if (!dateString.contains(" ")) {
                        if ((dateString = dateString.split(" ")[0].replaceAll("[^\\d]", "")).length() == 2) {
                            if (h.isAfter(date = LocalDate.of(date.getYear(), date.getMonth(), Integer.parseInt(dateString)))) {
                                date = date.plusMonths(1L);
                            }
                        } else if (dateString.length() == 4) {
                            if (h.isAfter(date = LocalDate.of(date.getYear(), Integer.parseInt(dateString.substring(2)), Integer.parseInt(dateString.substring(0, 2))))) {
                                date = date.plusYears(1L);
                            }
                        } else if (dateString.length() == 6) {
                            date = LocalDate.of(2000 + Integer.parseInt(dateString.substring(6)), Integer.parseInt(dateString.substring(2, 4)), Integer.parseInt(dateString.substring(0, 2)));
                            if (h.isAfter(date)) {
                                date = date.plusYears(100L);
                            }
                        } else if (dateString.length() == 8) {
                            date = LocalDate.of(Integer.parseInt(dateString.substring(6)), Integer.parseInt(dateString.substring(2, 4)), Integer.parseInt(dateString.substring(0, 2)));
                        }
                    } else {
                        String aux = dateString;
                        dateString = dateString.replaceAll("[^\\d]", "");
                    }
                }
            }
            if (date != null) {
                r = Result.ok((Object)date.atStartOfDay());
            }
        }
        return r;
    }
}

