/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasItems;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.event.LayoutEvents;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClassResource;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TwinColSelect;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.dnd.DragSourceExtension;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.ui.dnd.event.DragEndListener;
import com.vaadin.ui.dnd.event.DragStartListener;
import com.vaadin.ui.dnd.event.DropListener;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.dataProviders.JPQLListDataProvider;
import io.mateu.mdd.core.interfaces.AbstractStylist;
import io.mateu.mdd.core.interfaces.Card;
import io.mateu.mdd.core.interfaces.GridDecorator;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.DataProvider;
import io.mateu.mdd.shared.annotations.FieldsFilter;
import io.mateu.mdd.shared.annotations.FullWidth;
import io.mateu.mdd.shared.annotations.ModifyValuesOnly;
import io.mateu.mdd.shared.annotations.Money;
import io.mateu.mdd.shared.annotations.NotInlineEditable;
import io.mateu.mdd.shared.annotations.UseCheckboxes;
import io.mateu.mdd.shared.annotations.UseChips;
import io.mateu.mdd.shared.annotations.UseLinkToListView;
import io.mateu.mdd.shared.annotations.UseTable;
import io.mateu.mdd.shared.annotations.UseTwinCols;
import io.mateu.mdd.shared.annotations.WeekDays;
import io.mateu.mdd.shared.data.FareValue;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.fieldBuilders.AbstractFieldBuilder;
import io.mateu.mdd.vaadin.components.fieldBuilders.JPAManyToOneFieldBuilder;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.FieldInterfacedFromPath;
import io.mateu.reflection.FieldInterfacedFromType;
import io.mateu.reflection.MapEntry;
import io.mateu.reflection.ProxyClass;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

public class JPAOneToManyFieldBuilder
extends AbstractFieldBuilder {
    @Override
    public boolean isSupported(FieldInterfaced field) {
        boolean ok = Collection.class.isAssignableFrom(field.getType());
        if (ok) {
            Class gc = ReflectionHelper.getGenericClass((FieldInterfaced)field, Collection.class, (String)"E");
            ok &= !String.class.equals((Object)gc) && !Integer.class.equals((Object)gc) && !Long.class.equals((Object)gc) && !Float.class.equals((Object)gc) && !Double.class.equals((Object)gc) && !Boolean.class.equals((Object)gc);
        }
        if (!ok) {
            ok = Map.class.isAssignableFrom(field.getType());
        }
        return ok;
    }

    @Override
    public Component build(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, Map<String, List<AbstractAction>> attachedActions) {
        Component r = null;
        if (!forSearchFilter) {
            boolean owned = ReflectionHelper.isOwnedCollection((FieldInterfaced)field);
            r = Map.class.isAssignableFrom(field.getType()) ? this.buildMap(field, object, container, binder, validators, stylist, allFieldContainers, forSearchFilter, owned, attachedActions) : this.buildList(field, object, container, binder, validators, stylist, allFieldContainers, forSearchFilter, owned, attachedActions);
        }
        return r;
    }

    private Component buildList(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, boolean owned, Map<String, List<AbstractAction>> attachedActions) {
        CheckBoxGroup r = null;
        if (field.isAnnotationPresent(UseChips.class)) {
            HorizontalLayout hl = new HorizontalLayout();
            hl.addStyleName("nopadding");
            CssLayout l = new CssLayout();
            l.addStyleName("nopadding");
            hl.addComponent((Component)l);
            Button b = new Button("Add");
            l.addComponent((Component)b);
            b.addStyleName("link");
            b.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)hl);
            }
            hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
            this.bind(binder, l, field);
            this.addErrorHandler(field, (AbstractComponent)l);
            r = l;
        } else if (field.isAnnotationPresent(UseTwinCols.class)) {
            TwinColSelect tf = new TwinColSelect(container.getComponentCount() > 0 ? ReflectionHelper.getCaption((FieldInterfaced)field) : null);
            tf.setRows(10);
            tf.setLeftColumnCaption("Available options");
            tf.setRightColumnCaption("Selected options");
            if (field.isAnnotationPresent(FullWidth.class)) {
                tf.setWidth("100%");
            }
            this.addComponent(container, (Component)tf, attachedActions.get(field.getName()));
            JPAManyToOneFieldBuilder.setDataProvider((HasItems)tf, field, binder);
            tf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateReferences(binder, field, (HasValue.ValueChangeEvent<Set<Object>>)e));
            FieldInterfaced fName = ReflectionHelper.getNameField((Class)field.getGenericClass());
            if (fName != null) {
                tf.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> {
                    try {
                        return "" + ReflectionHelper.getValue((FieldInterfaced)fName, (Object)i);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return "Error";
                });
            }
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)tf);
            }
            tf.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            this.bind(binder, (TwinColSelect<Object>)tf, field);
            this.addErrorHandler(field, (AbstractComponent)tf);
            r = tf;
        } else if (field.isAnnotationPresent(UseLinkToListView.class)) {
            HorizontalLayout hl = new HorizontalLayout();
            Label l = new Label("");
            hl.addComponent((Component)l);
            l.addStyleName("collectionlinklabel");
            hl.addStyleName("clickable");
            hl.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
            hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)hl);
            }
            this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
            JPAOneToManyFieldBuilder.bind(binder, l, field, null);
            this.addErrorHandler(field, (AbstractComponent)l);
            r = l;
        } else if (field.isAnnotationPresent(UseCheckboxes.class)) {
            CheckBoxGroup cbg = new CheckBoxGroup();
            JPAManyToOneFieldBuilder.setDataProvider((HasItems)cbg, field, binder);
            cbg.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (e.isUserOriginated()) {
                    try {
                        ReflectionHelper.setValue((FieldInterfaced)field, (Object)binder.getBean(), (Object)e.getValue());
                    }
                    catch (Exception ex) {
                        Notifier.alert((Throwable)ex);
                    }
                }
            });
            cbg.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
            if (allFieldContainers != null) {
                allFieldContainers.put(field, (Component)cbg);
            }
            this.addComponent(container, (Component)cbg, attachedActions.get(field.getName()));
            this.bind(binder, cbg, field);
            this.addErrorHandler(field, (AbstractComponent)cbg);
            r = cbg;
        } else {
            Method mh = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "Html"));
            if (mh != null) {
                VerticalLayout hl = new VerticalLayout();
                hl.addStyleName("collectionlinklabel");
                Label l = new Label("", ContentMode.HTML);
                hl.addComponent((Component)l);
                hl.addStyleName("nopadding");
                hl.addStyleName("clickable");
                hl.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)hl);
                }
                this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                JPAOneToManyFieldBuilder.bind(binder, l, field, mh);
                this.addErrorHandler(field, (AbstractComponent)l);
                r = l;
            } else if (Card.class.isAssignableFrom(field.getGenericClass())) {
                CssLayout hl = new CssLayout();
                hl.addStyleName("collectionlinklabel");
                hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)hl);
                }
                this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                JPAOneToManyFieldBuilder.bind(binder, hl, field, mh);
                this.addErrorHandler(field, (AbstractComponent)hl);
                r = hl;
            } else if (IResource.class.isAssignableFrom(field.getGenericClass())) {
                CssLayout hl = new CssLayout();
                hl.addStyleName("nopadding");
                hl.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                if (allFieldContainers != null) {
                    allFieldContainers.put(field, (Component)hl);
                }
                hl.addStyleName("clickable");
                hl.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                this.addComponent(container, (Component)hl, attachedActions.get(field.getName()));
                this.bindResourcesList(binder, (Layout)hl, field);
                this.addErrorHandler(field, (AbstractComponent)hl);
                r = hl;
            } else {
                List editableFields;
                Grid g = new Grid();
                g.addStyleName("gridonetomany");
                g.addStyleName("nooutput");
                String colsFilter = "";
                if (field.isAnnotationPresent(UseTable.class)) {
                    colsFilter = ((UseTable)field.getAnnotation(UseTable.class)).fields();
                }
                if (Strings.isNullOrEmpty((String)colsFilter) && field.isAnnotationPresent(FieldsFilter.class)) {
                    colsFilter = ((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value();
                }
                List<FieldInterfaced> colFields = JPAOneToManyFieldBuilder.getColumnFields(field, colsFilter);
                List originalEditableFields = editableFields = ReflectionHelper.getAllEditableFields((Class)ReflectionHelper.getGenericClass((Type)field.getGenericType()), (Class)field.getDeclaringClass(), (boolean)false, (FieldInterfaced)field);
                Class targetClass = field.getGenericClass();
                Set subclasses = ReflectionHelper.getSubclasses((Class)targetClass);
                this.addErrorHandler(field, (AbstractComponent)g);
                r = g;
                boolean inline = false;
                if (owned && !field.isAnnotationPresent(UseTable.class)) {
                    inline = editableFields.size() <= colFields.size() && subclasses.size() == 0 && !field.isAnnotationPresent(NotInlineEditable.class);
                    inline = false;
                    if (inline) {
                        for (Object f : editableFields) {
                            if (this.isEditableInline((FieldInterfaced)f)) continue;
                            inline = false;
                            break;
                        }
                    }
                    if (inline) {
                        g.addStyleName("inline");
                        boolean needsProxy = false;
                        for (Object f : editableFields) {
                            if (!f.isAnnotationPresent(UseCheckboxes.class) || !((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) continue;
                            needsProxy = true;
                            break;
                        }
                    }
                }
                ListViewComponent.buildColumns(g, colFields, false, inline, binder, field, field.isAnnotationPresent(FieldsFilter.class) ? ((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value() : null);
                GridDecorator decorator = null;
                try {
                    Method m = ReflectionHelper.getMethod((Class)targetClass, (String)"getGridDecorator");
                    if (m != null) {
                        decorator = Modifier.isStatic(m.getModifiers()) ? (GridDecorator)m.invoke(null, new Object[0]) : (GridDecorator)m.invoke(ReflectionHelper.newInstance((Class)targetClass), new Object[0]);
                    } else if (GridDecorator.class.isAssignableFrom(targetClass)) {
                        decorator = (GridDecorator)ReflectionHelper.newInstance((Class)targetClass);
                    }
                    if (decorator != null) {
                        decorator.decorateGrid(g);
                    }
                }
                catch (Exception e2) {
                    Notifier.alert((Throwable)e2);
                }
                g.setSelectionMode(Grid.SelectionMode.MULTI);
                g.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
                if (inline) {
                    g.getEditor().getBinder().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                        Object bean = binder.getBean();
                        try {
                            ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean));
                            binder.setBean(bean);
                        }
                        catch (Exception ex) {
                            Notifier.alert((Throwable)ex);
                        }
                    });
                }
                int ancho = 0;
                for (Grid.Column col : g.getColumns()) {
                    ancho = (int)((double)ancho + col.getWidth());
                }
                if (ancho <= 0) {
                    ancho = 500;
                }
                boolean anchoCompleto = field.isAnnotationPresent(FullWidth.class) || ancho > 900;
                anchoCompleto = false;
                if (anchoCompleto) {
                    g.setWidth("100%");
                } else {
                    g.setWidth("" + (ancho + 55) + "px");
                }
                if (anchoCompleto) {
                    if (g.getColumns().size() == 1) {
                        ((Grid.Column)g.getColumns().get(0)).setExpandRatio(1);
                    } else {
                        g.addColumn((ValueProvider & Serializable)d -> null).setWidthUndefined().setCaption("");
                    }
                }
                g.setHeightMode(HeightMode.UNDEFINED);
                HorizontalLayout hl = new HorizontalLayout();
                hl.addStyleName("botoneracampo");
                if (owned) {
                    Button b;
                    JPAOneToManyFieldBuilder.bind(binder, g, field, targetClass, originalEditableFields, object);
                    if (field.isAnnotationPresent(ModifyValuesOnly.class) && (attachedActions.get(field.getName()) == null || attachedActions.get(field.getName()).size() == 0)) {
                        g.setSelectionMode(Grid.SelectionMode.NONE);
                    }
                    if (inline) {
                        g.getEditor().setEnabled(true);
                        g.getEditor().setBuffered(false);
                        if (!field.isAnnotationPresent(ModifyValuesOnly.class)) {
                            b = new Button((Resource)VaadinIcons.PLUS);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Object bean = binder.getBean();
                                    ReflectionHelper.addToCollection((FieldInterfaced)field, (Object)bean);
                                    binder.setBean(bean, false);
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            });
                        }
                    } else {
                        g.addItemClickListener((ItemClickListener & Serializable)e -> {
                            Object i;
                            if (e.getColumn() != null && (i = e.getItem()) != null) {
                                JPAOneToManyFieldBuilder.editar(binder, field, i, e.getRowIndex());
                            }
                        });
                        if (!field.isAnnotationPresent(ModifyValuesOnly.class) && ReflectionHelper.puedeAnadir((FieldInterfaced)field)) {
                            b = new Button((Resource)VaadinIcons.PLUS);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Constructor con = ReflectionHelper.getConstructor((Class)field.getGenericClass(), (Class)binder.getBeanType());
                                    if (con == null) {
                                        con = Arrays.stream(field.getGenericClass().getConstructors()).filter(c -> c.getParameterCount() == 0).findFirst().orElse(null);
                                    }
                                    if (con != null && Modifier.isPublic(con.getModifiers())) {
                                        try {
                                            Collection col = ReflectionHelper.addToCollection((FieldInterfaced)field, (Object)binder.getBean());
                                            Object i2 = Iterables.getLast((Iterable)col);
                                            JPAOneToManyFieldBuilder.editar(binder, field, i2, col.size() - 1);
                                        }
                                        catch (Exception ex) {
                                            Notifier.alert((Throwable)ex);
                                        }
                                    } else {
                                        con = ReflectionHelper.getConstructor((Class)field.getGenericClass());
                                        if (con != null && con.getParameterCount() > 0) {
                                            VaadinHelper.fill("I need some data", con, i -> {
                                                try {
                                                    Collection col = ReflectionHelper.addToCollection((FieldInterfaced)field, (Object)binder.getBean(), (Object)i);
                                                    JPAOneToManyFieldBuilder.editar(binder, field, i, col.size() - 1);
                                                }
                                                catch (Exception ex) {
                                                    Notifier.alert((Throwable)ex);
                                                }
                                            }, () -> MDDUIAccessor.goBack());
                                        } else {
                                            Notifier.alert((String)("No constructor found for " + field.getGenericClass().getSimpleName()));
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Notifier.alert((Throwable)ex);
                                }
                            });
                        }
                    }
                    if (!field.isAnnotationPresent(ModifyValuesOnly.class)) {
                        if (ReflectionHelper.puedeClonar((FieldInterfaced)field)) {
                            b = new Button((Resource)VaadinIcons.COPY);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Object bean = binder.getBean();
                                    for (Object o : g.getSelectedItems()) {
                                        if (o instanceof ProxyClass) {
                                            o = ((ProxyClass)o).toObject();
                                        }
                                        ReflectionHelper.addToCollection((FieldInterfaced)field, (Object)bean, (Object)ReflectionHelper.clone(o));
                                    }
                                    binder.setBean(bean, false);
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            });
                        }
                        if (ReflectionHelper.puedeBorrar((FieldInterfaced)field)) {
                            b = new Button((Resource)VaadinIcons.MINUS);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Object bean = binder.getBean();
                                    Set l = g.getSelectedItems().stream().map(o -> o != null && o instanceof ProxyClass ? ((ProxyClass)o).toObject() : o).collect(Collectors.toSet());
                                    ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)ReflectionHelper.removeAll((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean)), l));
                                    binder.setBean(bean, false);
                                }
                                catch (Throwable throwable) {
                                    Notifier.alert((Throwable)throwable);
                                }
                            });
                        }
                        if (ReflectionHelper.puedeOrdenar((FieldInterfaced)field)) {
                            b = new Button((Resource)VaadinIcons.ARROW_UP);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Object bean = binder.getBean();
                                    Collection col = (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean);
                                    if (col instanceof List) {
                                        int index;
                                        List l = (List)col;
                                        HashSet sel = new HashSet(g.getSelectedItems());
                                        boolean posible = true;
                                        for (Object o : sel) {
                                            index = l.indexOf(o);
                                            if (index != 0) continue;
                                            posible = false;
                                            break;
                                        }
                                        if (posible) {
                                            for (Object o : sel.stream().sorted((o1, o2) -> l.indexOf(o1) - l.indexOf(o2)).collect(Collectors.toList())) {
                                                index = l.indexOf(o);
                                                if (index <= 0) continue;
                                                l.remove(o);
                                                l.add(index - 1, o);
                                            }
                                            ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)l);
                                            g.deselectAll();
                                            binder.update(bean);
                                            sel.forEach(i -> g.select(i));
                                        }
                                    }
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            });
                            b = new Button((Resource)VaadinIcons.ARROW_DOWN);
                            hl.addComponent((Component)b);
                            b.addStyleName("quiet");
                            b.addStyleName("tiny");
                            b.addClickListener((Button.ClickListener & Serializable)e -> {
                                try {
                                    Object bean = binder.getBean();
                                    Collection col = (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean);
                                    if (col instanceof List) {
                                        int index;
                                        List l = (List)col;
                                        HashSet sel = new HashSet(g.getSelectedItems());
                                        boolean posible = true;
                                        for (Object o : sel) {
                                            index = l.indexOf(o);
                                            if (index != l.size() - 1) continue;
                                            posible = false;
                                            break;
                                        }
                                        if (posible) {
                                            for (Object o : sel.stream().sorted((o1, o2) -> l.indexOf(o2) - l.indexOf(o1)).collect(Collectors.toList())) {
                                                index = l.indexOf(o);
                                                if (index >= l.size() - 1) continue;
                                                l.remove(o);
                                                l.add(index + 1, o);
                                            }
                                            ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)l);
                                            g.deselectAll();
                                            binder.update(bean);
                                            sel.forEach(i -> g.select(i));
                                        }
                                    }
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            });
                        }
                    }
                } else {
                    Method mdp;
                    DataProvider dpa = field.isAnnotationPresent(DataProvider.class) ? (DataProvider)field.getAnnotation(DataProvider.class) : null;
                    boolean seleccion = false;
                    seleccion = Set.class.isAssignableFrom(field.getType()) ? true : (dpa == null ? (mdp = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)(ReflectionHelper.getGetter((String)field.getName()) + "DataProvider"))) != null : true);
                    if (seleccion) {
                        g.addStyleName("unclickable");
                        if (MDDUIAccessor.getPendingSelection() != null) {
                            g.setDataProvider((com.vaadin.data.provider.DataProvider)new ListDataProvider((Collection)MDDUIAccessor.getPendingSelection()));
                            MDDUIAccessor.setPendingSelection(null);
                        } else if (dpa != null) {
                            try {
                                g.setDataProvider((com.vaadin.data.provider.DataProvider)ReflectionHelper.newInstance((Class)dpa.dataProvider()));
                            }
                            catch (Exception e3) {
                                Notifier.alert((Throwable)e3);
                            }
                        } else if (Set.class.isAssignableFrom(field.getType())) {
                            try {
                                JPQLListDataProvider dp = null;
                                FieldInterfaced mbf = ReflectionHelper.getMapper((FieldInterfaced)field);
                                dp = mbf != null && mbf.isAnnotationPresent(ManyToOne.class) ? new JPQLListDataProvider("select x from " + targetClass.getName() + " x where x." + mbf.getName() + " = null order by x." + ReflectionHelper.getIdField((Class)targetClass).getName() + " asc") : new JPQLListDataProvider(targetClass);
                                g.setDataProvider((com.vaadin.data.provider.DataProvider)dp);
                            }
                            catch (Throwable throwable) {
                                Notifier.alert((Throwable)throwable);
                            }
                        } else {
                            JPAManyToOneFieldBuilder.setDataProvider((HasItems)g, field, binder);
                        }
                        this.bindSelection(binder, g, field);
                    } else {
                        JPAOneToManyFieldBuilder.bind(binder, g, field, targetClass, null);
                        g.addItemClickListener((ItemClickListener & Serializable)e -> {
                            Object i = e.getItem();
                            if (i != null) {
                                MDDUIAccessor.go((String)field.getName());
                            }
                        });
                        Button b = new Button((Resource)VaadinIcons.PLUS);
                        hl.addComponent((Component)b);
                        b.addStyleName("quiet");
                        b.addStyleName("tiny");
                        b.addClickListener((Button.ClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                        b = new Button((Resource)VaadinIcons.MINUS);
                        hl.addComponent((Component)b);
                        b.addStyleName("quiet");
                        b.addStyleName("tiny");
                        b.addClickListener((Button.ClickListener & Serializable)e -> {
                            try {
                                Object bean = binder.getBean();
                                Set l = g.getSelectedItems();
                                ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)ReflectionHelper.removeAll((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean)), (Collection)l));
                                binder.setBean(bean, false);
                            }
                            catch (Throwable throwable) {
                                Notifier.alert((Throwable)throwable);
                            }
                        });
                    }
                }
                if (hl.getComponentCount() > 0) {
                    VerticalLayout vl = new VerticalLayout(new Component[]{g, hl});
                    this.addComponent(container, (Component)vl, attachedActions.get(field.getName()));
                    vl.addStyleName("nopadding");
                    vl.addStyleName("contenedorbotoneracampo");
                    vl.addStyleName("conbotonera");
                    if (allFieldContainers != null) {
                        allFieldContainers.put(field, (Component)vl);
                    }
                } else {
                    this.addComponent(container, (Component)g, attachedActions.get(field.getName()));
                    if (allFieldContainers != null) {
                        allFieldContainers.put(field, (Component)g);
                    }
                }
            }
        }
        return r;
    }

    private static void editar(MDDBinder binder, FieldInterfaced field, Object i, int indice) {
        String state = MDDUIAccessor.getCurrentState();
        if (!state.endsWith("/")) {
            state = state + "/";
        }
        state = state + field.getName();
        try {
            MDDUIAccessor.goTo((String)state);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void bindSet(MDDBinder binder, final Label l, FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            Object v;

            public void setValue(Object o) {
                this.v = o;
                try {
                    Collection elems = (Collection)o;
                    String s = "";
                    if (o == null || elems.size() == 0) {
                        s = "No item";
                    } else {
                        for (Object x : elems) {
                            if (!"".equalsIgnoreCase(s)) {
                                s = s + ", ";
                            }
                            s = s + x;
                        }
                    }
                    l.setValue(s);
                }
                catch (Throwable e) {
                    Notifier.alert((Throwable)e);
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        aux.bind(field.getName());
    }

    public static void bind(MDDBinder binder, final Label l, final FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            Object v;

            public void setValue(Object o) {
                this.v = o;
                try {
                    Collection elems = (Collection)o;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    String colsFilter = "";
                    if (field.isAnnotationPresent(UseTable.class)) {
                        colsFilter = ((UseTable)field.getAnnotation(UseTable.class)).fields();
                    }
                    List<FieldInterfaced> cols = JPAOneToManyFieldBuilder.getColumnFields(field, colsFilter);
                    pw.println("<table class='onetomanytable'>");
                    pw.println("<thead><tr>");
                    cols.forEach(col -> pw.println("<th>" + Helper.capitalize((String)col.getName()) + "</th>"));
                    pw.println("</tr></thead>");
                    pw.println("<tbody>");
                    if (o == null || ((Collection)o).size() == 0) {
                        pw.println("<tr><td colspan='" + cols.size() + "'>----- Empty list -----</td></tr>");
                    } else {
                        for (Object e : elems) {
                            pw.println("<tr>");
                            for (FieldInterfaced col2 : cols) {
                                boolean num = false;
                                if (Integer.TYPE.equals(col2.getType()) || Integer.class.equals((Object)col2.getType())) {
                                    num = true;
                                } else if (Long.TYPE.equals(col2.getType()) || Long.class.equals((Object)col2.getType())) {
                                    num = true;
                                } else if (Double.TYPE.equals(col2.getType()) || Double.class.equals((Object)col2.getType())) {
                                    num = true;
                                }
                                Object v = ReflectionHelper.getValue((FieldInterfaced)col2, e);
                                if (v != null && col2.isAnnotationPresent(WeekDays.class)) {
                                    boolean[] wds = (boolean[])v;
                                    String s = "";
                                    for (int i = 0; i < wds.length; ++i) {
                                        s = s + (wds[i] ? "|" : "-");
                                    }
                                    v = s;
                                }
                                pw.println("<td " + (num ? " class= 'numeric'" : "") + ">" + (v != null ? v : "---") + "</td>");
                            }
                            pw.println("</tr>");
                        }
                    }
                    pw.println("</tbody>");
                    pw.println("<tfoot><tr>");
                    cols.forEach(col -> {
                        boolean num = false;
                        String s = "";
                        if (Integer.TYPE.equals(col.getType()) || Integer.class.equals((Object)col.getType())) {
                            int t = 0;
                            if (elems != null) {
                                for (Object elem : elems) {
                                    try {
                                        Object w = ReflectionHelper.getValue((FieldInterfaced)col, elem);
                                        t += ((Integer)w).intValue();
                                    }
                                    catch (NoSuchMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            s = s + t;
                            num = true;
                        } else if (Long.TYPE.equals(col.getType()) || Long.class.equals((Object)col.getType())) {
                            long t = 0L;
                            if (elems != null) {
                                for (Object elem : elems) {
                                    try {
                                        Object w = ReflectionHelper.getValue((FieldInterfaced)col, elem);
                                        t += ((Long)w).longValue();
                                    }
                                    catch (NoSuchMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            s = s + t;
                            num = true;
                        } else if (Double.TYPE.equals(col.getType()) || Double.class.equals((Object)col.getType())) {
                            double t = 0.0;
                            if (elems != null) {
                                for (Object elem : elems) {
                                    try {
                                        Object w = ReflectionHelper.getValue((FieldInterfaced)col, elem);
                                        if (w == null) continue;
                                        t += ((Double)w).doubleValue();
                                    }
                                    catch (NoSuchMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (col.isAnnotationPresent(Money.class)) {
                                DecimalFormat df = new DecimalFormat("##,###,###,###,##0.00");
                                s = df.format(t);
                            } else {
                                s = s + t;
                            }
                            num = true;
                        }
                        pw.println("<th " + (num ? " class= 'numeric'" : "") + ">" + s + "</th>");
                    });
                    pw.println("</tr></tfoot>");
                    pw.println("</table>");
                    l.setValue(sw.toString());
                }
                catch (Throwable e) {
                    Notifier.alert((Throwable)e);
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        aux.bind(field.getName());
    }

    private boolean isEditableInline(FieldInterfaced f) {
        boolean editable = false;
        if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
            editable = true;
        } else if (String.class.equals((Object)f.getType())) {
            editable = true;
        } else if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType())) {
            editable = true;
        } else if (Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType())) {
            editable = true;
        } else if (Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType())) {
            editable = true;
        } else if (LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType())) {
            editable = true;
        } else if (LocalTime.class.equals((Object)f.getType()) || LocalTime.class.equals((Object)f.getType())) {
            editable = true;
        } else if (f.getType().isEnum()) {
            editable = true;
        } else if (f.isAnnotationPresent(ManyToOne.class)) {
            editable = !IResource.class.isAssignableFrom(f.getType());
        } else if (f.isAnnotationPresent(UseCheckboxes.class)) {
            editable = ((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline();
        } else if (f.isAnnotationPresent(WeekDays.class)) {
            editable = true;
        } else if (FareValue.class.equals((Object)f.getType())) {
            editable = true;
        }
        return editable;
    }

    private Component buildMap(FieldInterfaced field, Object object, Layout container, MDDBinder binder, Map<HasValue, List<Validator>> validators, AbstractStylist stylist, Map<FieldInterfaced, Component> allFieldContainers, boolean forSearchFilter, boolean owned, Map<String, List<AbstractAction>> attachedActions) {
        Class keyType = ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"K");
        Class valueType = ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"V");
        Grid g = new Grid();
        g.addStyleName("gridonetomany");
        g.addStyleName("nooutput");
        ListViewComponent.buildColumns(g, JPAOneToManyFieldBuilder.getColumnFields(field), false, true);
        int ancho = 0;
        for (Grid.Column col : g.getColumns()) {
            ancho = (int)((double)ancho + col.getWidth());
        }
        if (ancho <= 0) {
            ancho = 500;
        }
        boolean anchoCompleto = field.isAnnotationPresent(FullWidth.class) || ancho > 900;
        anchoCompleto = false;
        if (anchoCompleto) {
            g.setWidth("100%");
        } else {
            g.setWidth("" + (ancho + 50) + "px");
        }
        if (anchoCompleto) {
            if (g.getColumns().size() == 1) {
                ((Grid.Column)g.getColumns().get(0)).setExpandRatio(1);
            } else {
                g.addColumn((ValueProvider & Serializable)d -> null).setWidthUndefined().setCaption("");
            }
        }
        g.setHeightMode(HeightMode.UNDEFINED);
        g.setSelectionMode(Grid.SelectionMode.MULTI);
        g.setCaption(ReflectionHelper.getCaption((FieldInterfaced)field));
        VerticalLayout vl = new VerticalLayout();
        vl.addStyleName("nopadding");
        vl.addComponent((Component)g);
        this.bindMap(binder, g, field);
        VerticalLayout lx = new VerticalLayout();
        lx.addStyleName("nopadding");
        ArrayList<FieldInterfaced> auxFields = new ArrayList<FieldInterfaced>();
        auxFields.add((FieldInterfaced)new FieldInterfacedFromType(ReflectionHelper.getGenericClass((ParameterizedType)((ParameterizedType)field.getGenericType()), Map.class, (String)"K"), "key"));
        auxFields.add((FieldInterfaced)new FieldInterfacedFromType(ReflectionHelper.getGenericClass((ParameterizedType)((ParameterizedType)field.getGenericType()), Map.class, (String)"V"), "value"));
        MDDBinder auxbinder = new MDDBinder(auxFields);
        HashMap m = new HashMap();
        auxbinder.setBean(m);
        VerticalLayout finalHl = lx;
        auxFields.forEach(arg_0 -> JPAOneToManyFieldBuilder.lambda$buildMap$8(m, (Layout)finalHl, auxbinder, attachedActions, arg_0));
        vl.addComponent((Component)lx);
        HorizontalLayout hl = new HorizontalLayout();
        g.getEditor().setEnabled(true);
        ((Grid.Column)g.getColumns().get(0)).setEditable(false);
        g.getEditor().setBuffered(false);
        g.setHeightMode(HeightMode.UNDEFINED);
        Button b = new Button("Put", (Resource)VaadinIcons.PLUS);
        hl.addComponent((Component)b);
        b.addStyleName("quiet");
        b.addStyleName("tiny");
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            Object bean = binder.getBean();
            Map aux = (Map)auxbinder.getBean();
            Object k = aux.get("key");
            Object v = aux.get("value");
            try {
                if (k != null) {
                    ReflectionHelper.addToMap((FieldInterfaced)field, (Object)bean, k, v);
                    binder.setBean(bean, false);
                }
            }
            catch (Exception e1) {
                Notifier.alert((Throwable)e1);
            }
        });
        b = new Button("Remove selected lines", (Resource)VaadinIcons.MINUS);
        hl.addComponent((Component)b);
        b.addStyleName("quiet");
        b.addStyleName("tiny");
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            try {
                Object bean = binder.getBean();
                Set l = g.getSelectedItems();
                ReflectionHelper.removeFromMap((FieldInterfaced)field, (Object)bean, (Set)l);
                binder.setBean(bean, false);
            }
            catch (Exception e1) {
                Notifier.alert((Throwable)e1);
            }
        });
        vl.addComponent((Component)hl);
        container.addComponent((Component)vl);
        this.addErrorHandler(field, (AbstractComponent)g);
        if (allFieldContainers != null) {
            allFieldContainers.put(field, (Component)vl);
        }
        return g;
    }

    private void bind(final MDDBinder binder, final CheckBoxGroup g, final FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            private List<HasValue.ValueChangeListener> listeners = new ArrayList<HasValue.ValueChangeListener>();

            public void setValue(Object o) {
                Set items = null;
                if (o == null) {
                    items = new HashSet();
                } else if (o instanceof Set) {
                    items = (Set)o;
                } else if (o instanceof List) {
                    items = new HashSet((List)o);
                }
                try {
                    ReflectionHelper.setValue((FieldInterfaced)field, (Object)binder.getBean(), items);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
                g.setValue(items);
            }

            public Object getValue() {
                return g.getValue() != null ? new HashSet(g.getValue()) : null;
            }

            public Registration addValueChangeListener(final HasValue.ValueChangeListener valueChangeListener) {
                this.listeners.add(valueChangeListener);
                return new Registration(){

                    public void remove() {
                        listeners.remove(valueChangeListener);
                    }
                };
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        aux.bind(field.getName());
    }

    private void bindMap(MDDBinder binder, final Grid g, final FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){

            public void setValue(Object o) {
                Collection<Object> items = null;
                if (o == null) {
                    items = new ArrayList();
                } else if (o instanceof Map) {
                    Class keyType = ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"K");
                    if (keyType == null || keyType.isEnum()) {
                        // empty if block
                    }
                    items = ((Map)o).entrySet();
                } else {
                    items = (Collection)o;
                }
                g.setDataProvider((com.vaadin.data.provider.DataProvider)new ListDataProvider(items));
            }

            public Object getValue() {
                return ((ListDataProvider)g.getDataProvider()).getItems();
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        if (Map.class.isAssignableFrom(field.getType())) {
            aux.withConverter(new Converter(){

                public Result convertToModel(Object o, ValueContext valueContext) {
                    HashMap m = new HashMap();
                    if (o != null) {
                        ((Collection)o).forEach(e -> m.put(((MapEntry)e).getKey(), ((MapEntry)e).getValue()));
                    }
                    return Result.ok(o != null ? m : null);
                }

                public Object convertToPresentation(Object o, ValueContext valueContext) {
                    return o != null ? JPAOneToManyFieldBuilder.toList((Map)o) : null;
                }
            });
        }
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        aux.bind(field.getName());
    }

    private void updateReferences(MDDBinder binder, FieldInterfaced field, HasValue.ValueChangeEvent<Set<Object>> e) {
        Object bean = binder.getBean();
    }

    private Object toId(Object row) {
        return ReflectionHelper.getId((Object)row);
    }

    public static List<FieldInterfaced> getColumnFields(FieldInterfaced field, String filter) {
        List<FieldInterfaced> l;
        if (Strings.isNullOrEmpty((String)filter)) {
            l = JPAOneToManyFieldBuilder.getColumnFields(field);
        } else {
            l = new ArrayList<FieldInterfaced>();
            List aux = ReflectionHelper.getAllFields((Class)field.getGenericClass());
            String limpio = "";
            for (String s : filter.split(",")) {
                String n = s.trim();
                if (n.contains("(")) {
                    n = n.substring(0, n.indexOf("("));
                }
                if (n.contains(" ")) {
                    n = n.substring(0, n.indexOf(" "));
                }
                if (!"".equals(limpio)) {
                    limpio = limpio + ",";
                }
                limpio = limpio + n;
            }
            List<String> fns = Arrays.asList(limpio.replaceAll(" ", "").split(","));
            for (String fn : fns) {
                if (fn.contains(".")) {
                    l.add((FieldInterfaced)new FieldInterfacedFromPath(field.getGenericClass(), fn));
                    continue;
                }
                List<FieldInterfaced> finalL = l;
                aux.stream().filter(f -> fn.equals(f.getName())).findFirst().ifPresent(f -> finalL.add((FieldInterfaced)f));
            }
        }
        return l;
    }

    public static List<FieldInterfaced> getColumnFields(FieldInterfaced field) {
        ArrayList<FieldInterfaced> l = null;
        if (Map.class.isAssignableFrom(field.getType())) {
            l = new ArrayList<FieldInterfacedFromType>();
            l.add((FieldInterfaced)new FieldInterfacedFromType(ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"K"), "key"));
            l.add((FieldInterfaced)new FieldInterfacedFromType(ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"V"), "value"));
        } else {
            l = JPAOneToManyFieldBuilder.getColumnFields(field, field.getGenericClass());
        }
        return l;
    }

    public static List<FieldInterfaced> getColumnFields(FieldInterfaced field, Class rowType) {
        String mb;
        List<FieldInterfaced> l = null;
        l = ListViewComponent.getColumnFields(rowType, true, field.isAnnotationPresent(FieldsFilter.class) ? ((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value() : null, new ArrayList<String>(), new HashMap<String, FieldInterfaced>());
        OneToMany aa = (OneToMany)field.getAnnotation(OneToMany.class);
        if (aa != null && !Strings.isNullOrEmpty((String)(mb = ((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy()))) {
            FieldInterfaced mbf = null;
            for (FieldInterfaced f : l) {
                if (!f.getName().equals(mb)) continue;
                mbf = f;
                break;
            }
            if (mbf != null) {
                l.remove(mbf);
            }
        }
        if (field.isAnnotationPresent(FieldsFilter.class)) {
            List<String> fns = Arrays.asList(((FieldsFilter)field.getAnnotation(FieldsFilter.class)).value().split(","));
            fns = fns.stream().map(s -> s.trim()).collect(Collectors.toList());
            ArrayList<FieldInterfaced> borrar = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f : l) {
                if (fns.contains(f.getName())) continue;
                borrar.add(f);
            }
            l.removeAll(borrar);
        }
        return l;
    }

    public Object convert(String s) {
        return s;
    }

    public void addValidators(List<Validator> validators) {
    }

    private void bindSelection(MDDBinder binder, final Grid g, FieldInterfaced field) {
        HasValue hv = new HasValue(){
            List<HasValue.ValueChangeListener> valueChangeListeners = new ArrayList<HasValue.ValueChangeListener>();
            {
                g.getSelectionModel().addSelectionListener((SelectionListener & Serializable)e -> {
                    HasValue.ValueChangeEvent vce = new HasValue.ValueChangeEvent((Component)g, (HasValue)this, null, e.isUserOriginated());
                    this.valueChangeListeners.forEach(l -> l.valueChange(vce));
                });
            }

            public void setValue(Object o) {
                g.deselectAll();
                if (o != null) {
                    if (o instanceof Collection) {
                        ((Collection)o).forEach(i -> g.select(i));
                    } else {
                        g.select(o);
                    }
                }
            }

            public Object getValue() {
                return g.getSelectedItems();
            }

            public Registration addValueChangeListener(final HasValue.ValueChangeListener valueChangeListener) {
                this.valueChangeListeners.add(valueChangeListener);
                return new Registration(){

                    public void remove() {
                        valueChangeListeners.remove(valueChangeListener);
                    }
                };
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        };
        Binder.BindingBuilder aux = binder.forField(hv);
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        Binder.Binding b = aux.bind(field.getName());
        hv.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateReferences(binder, field, (HasValue.ValueChangeEvent<Set<Object>>)e));
        if (Set.class.isAssignableFrom(field.getType())) {
            try {
                ReflectionHelper.setValue((FieldInterfaced)field, (Object)binder.getBean(), new HashSet());
            }
            catch (Exception e2) {
                Notifier.alert((Throwable)e2);
            }
        }
    }

    private void bind(final MDDBinder binder, final CssLayout l, final FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            Object value;

            public void setValue(Object o) {
                this.value = o;
                Button b = (Button)l.getComponent(l.getComponentCount() - 1);
                l.removeAllComponents();
                if (o == null || ((Collection)o).size() == 0) {
                    l.addComponent((Component)new Label("Empty list"));
                } else {
                    for (Object x : (Collection)o) {
                        l.addComponent(JPAOneToManyFieldBuilder.this.createChip(binder, field, x));
                    }
                }
                l.addComponent((Component)b);
            }

            public Object getValue() {
                return this.value;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        JPAOneToManyFieldBuilder.completeBinding(aux, binder, field);
    }

    private Component createChip(MDDBinder binder, FieldInterfaced field, Object x) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.addStyleName("chip");
        Label l = new Label(x.toString());
        hl.addComponent((Component)l);
        Button b = new Button(null, (Resource)VaadinIcons.CLOSE_SMALL);
        hl.addComponent((Component)b);
        b.addClickListener((Button.ClickListener & Serializable)e -> {
            try {
                Object bean = binder.getBean();
                ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, (Object)ReflectionHelper.removeAll((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean)), (Collection)Sets.newHashSet((Object[])new Object[]{x})));
                binder.setBean(bean, false);
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        });
        return hl;
    }

    private void bindResourcesList(MDDBinder binder, final Layout l, FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            private Object v;

            public void setValue(Object o) {
                this.v = o;
                l.removeAllComponents();
                if (o == null || ((Collection)o).size() == 0) {
                    Label label = new Label(VaadinIcons.PLUS.getHtml());
                    l.addComponent((Component)label);
                    label.setContentMode(ContentMode.HTML);
                    label.addStyleName("fileicon");
                } else {
                    try {
                        for (Object i : (Collection)o) {
                            String u;
                            IResource file = (IResource)i;
                            boolean empty = true;
                            if (file != null && file.getName() != null && !Strings.isNullOrEmpty((String)(u = file.toFileLocator().getUrl()))) {
                                if (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg") || file.getName().toLowerCase().endsWith(".gif") || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".svg") || file.getName().toLowerCase().endsWith(".webp")) {
                                    Image image = new Image();
                                    image.setWidth("130px");
                                    image.setSource((Resource)(!Strings.isNullOrEmpty((String)u) ? new ExternalResource(u) : new ClassResource("/images/noimage.png")));
                                    l.addComponent((Component)image);
                                } else {
                                    Label label = new Label(VaadinIcons.FILE.getHtml());
                                    l.addComponent((Component)label);
                                    label.setContentMode(ContentMode.HTML);
                                    label.addStyleName("fileicon");
                                }
                                empty = false;
                            }
                            if (!empty) continue;
                            Image image = new Image();
                            image.setWidth("130px");
                            image.setSource((Resource)new ClassResource("/images/noimage.png"));
                            l.addComponent((Component)image);
                        }
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        JPAOneToManyFieldBuilder.completeBinding(aux, binder, field);
    }

    static void bind(MDDBinder binder, CssLayout l, FieldInterfaced field, Method htmlGetter) {
        JPAOneToManyFieldBuilder.bind(binder, l, field, htmlGetter, false);
    }

    static void bind(final MDDBinder binder, final CssLayout l, final FieldInterfaced field, Method htmlGetter, final boolean output) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            private Object v;

            public void setValue(Object o) {
                this.v = o;
                l.removeAllComponents();
                if (o == null || ((Collection)o).size() == 0) {
                    HorizontalLayout clickable = new HorizontalLayout(new Component[]{new Label("Empty list")});
                    l.addComponent((Component)clickable);
                    clickable.addStyleName("nopadding");
                    if (!output) {
                        clickable.addStyleName("clickable");
                        clickable.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> MDDUIAccessor.go((String)field.getName()));
                    }
                } else {
                    int pos = 0;
                    for (Object i : (Collection)o) {
                        Component[] componentArray = new Component[1];
                        Label lab = new Label(((Card)i).toHtml(), ContentMode.HTML);
                        componentArray[0] = lab;
                        HorizontalLayout clickable = new HorizontalLayout(componentArray);
                        l.addComponent((Component)clickable);
                        clickable.addStyleName("carditem");
                        if (!output) {
                            clickable.addStyleName("clickable");
                            int finalPos = pos;
                            clickable.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)e -> {
                                if (i != null) {
                                    JPAOneToManyFieldBuilder.editar(binder, field, i, finalPos);
                                }
                            });
                            if (ReflectionHelper.puedeOrdenar((FieldInterfaced)field)) {
                                DragSourceExtension dragSource = new DragSourceExtension((AbstractComponent)clickable);
                                dragSource.setEffectAllowed(EffectAllowed.MOVE);
                                dragSource.setDataTransferText("hello receiver");
                                dragSource.setDataTransferData("text/html", "<label>hello receiver</label>");
                                dragSource.addDragStartListener((DragStartListener & Serializable)event -> dragSource.setDragData(i));
                                dragSource.addDragEndListener((DragEndListener & Serializable)event -> dragSource.setDragData(null));
                                clickable.setPrimaryStyleName("zonadrop");
                                DropTargetExtension dropTarget = new DropTargetExtension((AbstractComponent)clickable);
                                dropTarget.setDropEffect(DropEffect.MOVE);
                                dropTarget.addDropListener((DropListener & Serializable)event -> {
                                    Optional dragSourcex = event.getDragSourceComponent();
                                    if (dragSourcex.isPresent() && dragSourcex.get() instanceof HorizontalLayout) {
                                        event.getDragData().ifPresent(data -> {
                                            System.out.println("recibido: " + data);
                                            if (!i.equals(data)) {
                                                Object bean = binder.getBean();
                                                try {
                                                    ArrayList<Object> l2 = new ArrayList<Object>((Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean));
                                                    l2.remove(data);
                                                    l2.add(l2.indexOf(i), data);
                                                    ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, l2);
                                                    binder.update(bean);
                                                }
                                                catch (Exception e) {
                                                    Notifier.alert((Throwable)e);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        ++pos;
                    }
                    if (!output && ReflectionHelper.puedeOrdenar((FieldInterfaced)field)) {
                        Component[] componentArray = new Component[1];
                        Label lab = new Label("<div style='width: 30px; height: 50px;'></div>", ContentMode.HTML);
                        componentArray[0] = lab;
                        HorizontalLayout clickable = new HorizontalLayout(componentArray);
                        l.addComponent((Component)clickable);
                        clickable.setPrimaryStyleName("zonadrop");
                        DropTargetExtension dropTarget = new DropTargetExtension((AbstractComponent)clickable);
                        dropTarget.setDropEffect(DropEffect.MOVE);
                        dropTarget.addDropListener((DropListener & Serializable)event -> {
                            Optional dragSourcex = event.getDragSourceComponent();
                            if (dragSourcex.isPresent() && dragSourcex.get() instanceof HorizontalLayout) {
                                event.getDragData().ifPresent(data -> {
                                    System.out.println("recibido: " + data);
                                    Object bean = binder.getBean();
                                    try {
                                        ArrayList<Object> l2 = new ArrayList<Object>((Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)bean));
                                        l2.remove(data);
                                        l2.add(data);
                                        ReflectionHelper.setValue((FieldInterfaced)field, (Object)bean, l2);
                                        binder.update(bean);
                                    }
                                    catch (Exception e) {
                                        Notifier.alert((Throwable)e);
                                    }
                                });
                            }
                        });
                    }
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        JPAOneToManyFieldBuilder.completeBinding(aux, binder, field);
    }

    static void bind(final MDDBinder binder, final Label l, FieldInterfaced field, final Method htmlGetter) {
        Binder.BindingBuilder aux = binder.forField(new HasValue(){
            private Object v;

            public void setValue(Object o) {
                this.v = o;
                if (o == null || ((Collection)o).size() == 0) {
                    l.setValue("Empty list");
                } else {
                    try {
                        l.setValue(htmlGetter != null ? (String)htmlGetter.invoke(binder.getBean(), new Object[0]) : "" + ((Collection)o).size() + " items");
                    }
                    catch (Exception e) {
                        Notifier.alert((Throwable)e);
                    }
                }
            }

            public Object getValue() {
                return this.v;
            }

            public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                return null;
            }

            public void setRequiredIndicatorVisible(boolean b) {
            }

            public boolean isRequiredIndicatorVisible() {
                return false;
            }

            public void setReadOnly(boolean b) {
            }

            public boolean isReadOnly() {
                return false;
            }
        });
        aux.withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        JPAOneToManyFieldBuilder.completeBinding(aux, binder, field);
    }

    public static void bind(MDDBinder binder, Grid g, FieldInterfaced field, Class targetClass, List<FieldInterfaced> originalEditableFields) {
        JPAOneToManyFieldBuilder.bind(binder, g, field, targetClass, originalEditableFields, null);
    }

    public static void bind(final MDDBinder binder, final Grid g, final FieldInterfaced field, final Class targetClass, final List<FieldInterfaced> originalEditableFields, final Object owner) {
        if (ProxyClass.class.isAssignableFrom(targetClass)) {
            HasValue hv = new HasValue(){
                private Object v;

                public void setValue(Object o) {
                    this.v = o;
                    Collection<Object> items = null;
                    if (o == null) {
                        items = new ArrayList();
                    } else if (o instanceof Map) {
                        items = new ArrayList();
                        Class keyType = ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"K");
                        if (keyType == null || keyType.isEnum()) {
                            // empty if block
                        }
                        items = ((Map)o).entrySet();
                    } else {
                        items = new ArrayList();
                        HashMap valoresPosiblesPorCampo = new HashMap();
                        for (FieldInterfaced f : originalEditableFields) {
                            if (!f.isAnnotationPresent(UseCheckboxes.class) || !((UseCheckboxes)f.getAnnotation(UseCheckboxes.class)).editableInline()) continue;
                            Collection possibleValues = null;
                            String vmn = ReflectionHelper.getGetter((String)(field.getName() + ReflectionHelper.getFirstUpper((String)f.getName()))) + "Values";
                            Method mdp = ReflectionHelper.getMethod((Class)field.getDeclaringClass(), (String)vmn);
                            if (mdp != null) {
                                try {
                                    possibleValues = (Collection)mdp.invoke(owner, new Object[0]);
                                }
                                catch (Exception e) {
                                    Notifier.alert((Throwable)e);
                                }
                            } else {
                                Notifier.alert((String)("Missing " + vmn + " method at " + field.getDeclaringClass().getName()));
                            }
                            int pos = 0;
                            if (possibleValues == null) continue;
                            HashMap l = (HashMap)valoresPosiblesPorCampo.get(f.getName());
                            if (l == null) {
                                l = new HashMap();
                                valoresPosiblesPorCampo.put(f.getName(), l);
                            }
                            for (Object v : possibleValues) {
                                if (v == null) continue;
                                l.put(pos, v);
                                ++pos;
                            }
                        }
                        for (Object x : (Collection)o) {
                            try {
                                items.add(targetClass.getConstructor(x.getClass(), Map.class, MDDBinder.class).newInstance(new Object[]{x, valoresPosiblesPorCampo, binder}));
                            }
                            catch (InstantiationException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    g.setDataProvider((com.vaadin.data.provider.DataProvider)new ListDataProvider(items));
                }

                public Object getValue() {
                    ArrayList<Object> items = new ArrayList<Object>();
                    for (Object o : ((ListDataProvider)g.getDataProvider()).getItems()) {
                        items.add(((ProxyClass)o).toObject());
                    }
                    return items;
                }

                public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                    return null;
                }

                public void setRequiredIndicatorVisible(boolean b) {
                }

                public boolean isRequiredIndicatorVisible() {
                    return false;
                }

                public void setReadOnly(boolean b) {
                }

                public boolean isReadOnly() {
                    return false;
                }
            };
            JPAOneToManyFieldBuilder.completeBinding(hv, binder, field);
        } else {
            HasValue hv = new HasValue(){
                private Object v;

                public void setValue(Object o) {
                    this.v = o;
                    Collection<Object> items = null;
                    if (o == null) {
                        items = new ArrayList();
                    } else if (o instanceof Map) {
                        Class keyType = ReflectionHelper.getGenericClass((FieldInterfaced)field, Map.class, (String)"K");
                        if (keyType == null || keyType.isEnum()) {
                            // empty if block
                        }
                        items = ((Map)o).entrySet();
                    } else {
                        items = (Collection)o;
                    }
                    g.setDataProvider((com.vaadin.data.provider.DataProvider)new ListDataProvider(items));
                }

                public Object getValue() {
                    return ((ListDataProvider)g.getDataProvider()).getItems();
                }

                public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
                    return null;
                }

                public void setRequiredIndicatorVisible(boolean b) {
                }

                public boolean isRequiredIndicatorVisible() {
                    return false;
                }

                public void setReadOnly(boolean b) {
                }

                public boolean isReadOnly() {
                    return false;
                }
            };
            JPAOneToManyFieldBuilder.completeBinding(hv, binder, field);
        }
    }

    private static List<MapEntry> toList(Map m) {
        ArrayList<MapEntry> l = new ArrayList<MapEntry>();
        if (m != null) {
            m.entrySet().forEach(e -> l.add(new MapEntry(((Map.Entry)e).getKey(), ((Map.Entry)e).getValue())));
        }
        return m != null ? l : null;
    }

    protected void bind(MDDBinder binder, TwinColSelect<Object> tf, FieldInterfaced field) {
        Binder.BindingBuilder aux = binder.forField((HasValue)tf).withValidator((Validator)new BeanValidator(field.getDeclaringClass(), field.getName()));
        JPAOneToManyFieldBuilder.completeBinding(aux, binder, field);
    }

    private static /* synthetic */ void lambda$buildMap$8(Map m, Layout finalHl, MDDBinder auxbinder, Map attachedActions, FieldInterfaced f) {
        AbstractFieldBuilder b = (AbstractFieldBuilder)MDDUIAccessor.getFieldBuilder((FieldInterfaced)f);
        if (b != null) {
            b.build(f, m, finalHl, auxbinder, null, null, null, false, attachedActions);
        }
    }

    private static /* synthetic */ void lambda$buildList$a35bd470$4(FieldInterfaced field, LayoutEvents.LayoutClickEvent e) {
        MDDUIAccessor.go((String)field.getName());
    }
}

