/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders.components;

import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import io.mateu.mdd.shared.annotations.Html;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.GeneralRepository;
import io.mateu.util.interfaces.Translated;
import io.mateu.util.notification.Notifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class LiteralComponent
extends Composite
implements HasValue<Translated>,
Component.Focusable {
    private final AbstractField<String> tf;
    private final ComboBox<String> cb;
    private final MDDBinder binder;
    private Translated literal;
    private Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();

    public LiteralComponent(FieldInterfaced field, MDDBinder binder) {
        this.binder = binder;
        ArrayList langs = Lists.newArrayList((Object[])new String[]{"es", "en", "de", "fr", "it", "ar", "cz", "ru"});
        this.tf = field.isAnnotationPresent(Html.class) ? new RichTextArea() : (field.isAnnotationPresent(io.mateu.mdd.shared.annotations.TextArea.class) ? new TextArea() : new TextField());
        Component[] componentArray = new Component[3];
        componentArray[0] = this.tf;
        this.cb = new ComboBox(null, (Collection)langs);
        componentArray[1] = this.cb;
        Button b = new Button("<i class=\"fas fa-language\"></i>", (Button.ClickListener & Serializable)e -> Notifier.alert((String)"DeepL is not configured. Please contact your administrator."));
        componentArray[2] = b;
        HorizontalLayout hl = new HorizontalLayout(componentArray);
        b.setCaptionAsHtml(true);
        this.cb.setWidth("80px");
        this.cb.setEmptySelectionAllowed(false);
        this.cb.setValue((Object)"es");
        this.cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.literal != null) {
                String v = this.literal.getEs();
                if ("en".equals(e.getValue())) {
                    v = this.literal.getEn();
                }
                if ("de".equals(e.getValue())) {
                    v = this.literal.getDe();
                }
                if ("fr".equals(e.getValue())) {
                    v = this.literal.getFr();
                }
                if ("it".equals(e.getValue())) {
                    v = this.literal.getIt();
                }
                if ("ar".equals(e.getValue())) {
                    v = this.literal.getAr();
                }
                if ("cz".equals(e.getValue())) {
                    v = this.literal.getCz();
                }
                if ("ru".equals(e.getValue())) {
                    v = this.literal.getRu();
                }
                if (v == null) {
                    v = "";
                }
                this.tf.setValue((Object)v);
            }
        });
        this.setCompositionRoot((Component)hl);
        if (this.tf instanceof AbstractTextField) {
            ((AbstractTextField)this.tf).setValueChangeMode(ValueChangeMode.BLUR);
        }
        this.tf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isUserOriginated()) {
                if ("en".equals(this.cb.getValue())) {
                    this.literal.setEn((String)e.getValue());
                } else if ("de".equals(this.cb.getValue())) {
                    this.literal.setDe((String)e.getValue());
                } else if ("fr".equals(this.cb.getValue())) {
                    this.literal.setFr((String)e.getValue());
                } else if ("it".equals(this.cb.getValue())) {
                    this.literal.setIt((String)e.getValue());
                } else if ("ar".equals(this.cb.getValue())) {
                    this.literal.setAr((String)e.getValue());
                } else if ("cz".equals(this.cb.getValue())) {
                    this.literal.setCz((String)e.getValue());
                } else if ("ru".equals(this.cb.getValue())) {
                    this.literal.setRu((String)e.getValue());
                } else {
                    this.literal.setEs((String)e.getValue());
                }
            }
            HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)this, (Object)this, e.isUserOriginated());
            this.listeners.values().forEach(l -> l.valueChange(ce));
        });
    }

    public void setValue(Translated o) {
        this.literal = o;
        if (this.literal == null) {
            try {
                this.literal = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).getNewTranslated();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        if (this.literal != null) {
            String v = this.literal.getEs();
            if ("en".equals(this.cb.getValue())) {
                v = this.literal.getEn();
            }
            if ("de".equals(this.cb.getValue())) {
                v = this.literal.getDe();
            }
            if ("fr".equals(this.cb.getValue())) {
                v = this.literal.getFr();
            }
            if ("it".equals(this.cb.getValue())) {
                v = this.literal.getIt();
            }
            if ("ar".equals(this.cb.getValue())) {
                v = this.literal.getAr();
            }
            if ("cz".equals(this.cb.getValue())) {
                v = this.literal.getCz();
            }
            if ("ru".equals(this.cb.getValue())) {
                v = this.literal.getRu();
            }
            if (v == null) {
                v = "";
            }
            this.tf.setValue((Object)v);
        }
    }

    public Translated getValue() {
        return this.literal;
    }

    public void setRequiredIndicatorVisible(boolean b) {
        this.tf.setRequiredIndicatorVisible(b);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.tf.isRequiredIndicatorVisible();
    }

    public void setReadOnly(boolean b) {
        this.tf.setReadOnly(b);
    }

    public boolean isReadOnly() {
        return this.tf.isReadOnly();
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<Translated> valueChangeListener) {
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                LiteralComponent.this.listeners.remove(this.id);
            }
        };
    }

    public void focus() {
        this.tf.focus();
    }

    public int getTabIndex() {
        return this.tf.getTabIndex();
    }

    public void setTabIndex(int i) {
        this.tf.setTabIndex(i);
    }
}

