/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.fieldBuilders.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.event.MouseEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClassResource;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Composite;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Link;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import io.mateu.mdd.shared.interfaces.FileType;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.GeneralRepository;
import io.mateu.util.notification.Notifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceComponent
extends Composite
implements HasValue<IResource>,
Component.Focusable {
    private static final Logger log = LoggerFactory.getLogger(ResourceComponent.class);
    private final MDDBinder binder;
    private final Link hyperLink;
    private final Upload upload;
    private final Image image;
    private final ComboBox<FileType> cb;
    private final TextField url;
    private IResource file;
    private Map<UUID, HasValue.ValueChangeListener> listeners = new HashMap<UUID, HasValue.ValueChangeListener>();

    public ResourceComponent(FieldInterfaced field, MDDBinder binder) {
        this.binder = binder;
        class MyUploader
        implements Upload.Receiver,
        Upload.SucceededListener {
            public File filex;

            MyUploader() {
            }

            public OutputStream receiveUpload(String fileName, String mimeType) {
                System.out.println("receiveUpload(" + fileName + "," + mimeType + ")");
                FileOutputStream os = null;
                if (fileName != null && !"".equals(fileName)) {
                    String id = UUID.randomUUID().toString();
                    String extension = ".tmp";
                    if (fileName == null || "".equals(fileName.trim())) {
                        fileName = "" + id + extension;
                    }
                    if (fileName.lastIndexOf(".") < fileName.length() - 1) {
                        extension = fileName.substring(fileName.lastIndexOf("."));
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    File temp = null;
                    try {
                        this.filex = temp = File.createTempFile(fileName, extension);
                        os = new FileOutputStream(this.filex);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return os;
            }

            public void uploadSucceeded(Upload.SucceededEvent event) {
                String baseUrl = System.getProperty("tmpurl");
                URL url = null;
                try {
                    url = baseUrl == null ? this.filex.toURI().toURL() : new URL(baseUrl + "/" + this.filex.getName());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                System.out.println("uploadSucceeded(" + this.filex.getAbsolutePath() + ")");
                try {
                    if (ResourceComponent.this.file == null) {
                        ResourceComponent.this.file = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).getNewResource();
                    }
                    ResourceComponent.this.file.set(this.filex.getName(), this.filex.getAbsolutePath());
                    HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)ResourceComponent.this, (Object)ResourceComponent.this, true);
                    ResourceComponent.this.listeners.values().forEach(l -> l.valueChange(ce));
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            }
        }
        MyUploader receiver = new MyUploader();
        this.upload = new Upload(null, (Upload.Receiver)receiver);
        this.upload.addSucceededListener((Upload.SucceededListener)receiver);
        HorizontalLayout h = new HorizontalLayout();
        h.setSpacing(true);
        this.hyperLink = new Link();
        h.addComponent((Component)this.hyperLink);
        this.image = new Image();
        h.addComponent((Component)this.image);
        this.image.setWidth("130px");
        this.image.setVisible(false);
        this.image.addClickListener((MouseEvents.ClickListener & Serializable)e -> {
            if (this.file != null) {
                String u = null;
                try {
                    u = this.file.toFileLocator().getUrl();
                }
                catch (Exception e1) {
                    Notifier.alert((Throwable)e1);
                }
                if (!Strings.isNullOrEmpty((String)u)) {
                    this.getUI().getPage().open(u, "_blank");
                }
            }
        });
        VerticalLayout v = new VerticalLayout();
        h.addComponent((Component)v);
        v.addStyleName("nopadding");
        v.addComponent((Component)new Button((Resource)VaadinIcons.CLOSE, new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                if (ResourceComponent.this.file != null) {
                    ResourceComponent.this.file.setName(null);
                    ResourceComponent.this.file.setUrl(null);
                    ResourceComponent.this.file.setBytes(null);
                    ResourceComponent.this.file.setUrl(null);
                }
                HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)ResourceComponent.this, (Object)ResourceComponent.this, true);
                ResourceComponent.this.listeners.values().forEach(l -> l.valueChange(ce));
            }
        }));
        this.url = new TextField();
        this.cb = new ComboBox(null, (Collection)Lists.newArrayList((Object[])new FileType[]{FileType.BYTES, FileType.URL}));
        this.cb.setWidth("120px");
        this.cb.setValue((Object)FileType.BYTES);
        this.cb.setEmptySelectionAllowed(false);
        this.cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.file == null) {
                try {
                    this.file = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).getNewResource();
                    if (FileType.BYTES.equals(e.getValue())) {
                        this.upload.setVisible(true);
                        this.url.setVisible(false);
                        this.file.setType((FileType)e.getValue());
                    } else {
                        this.upload.setVisible(false);
                        this.url.setVisible(true);
                        this.file.setType((FileType)e.getValue());
                    }
                }
                catch (Exception ex) {
                    Notifier.alert((Throwable)ex);
                }
            }
            HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)this, (Object)this, true);
            this.listeners.values().forEach(l -> l.valueChange(ce));
        });
        v.addComponent(this.cb);
        this.url.setWidth("250px");
        this.url.setVisible(false);
        this.url.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.file == null) {
                try {
                    this.file = ((GeneralRepository)Helper.getImpl(GeneralRepository.class)).getNewResource();
                }
                catch (Exception ex) {
                    Notifier.alert((Throwable)ex);
                }
            }
            if (FileType.URL.equals(this.cb.getValue())) {
                if (this.file != null) {
                    try {
                        this.file.set((String)e.getValue());
                    }
                    catch (Exception e1) {
                        Notifier.alert((Throwable)e1);
                    }
                }
                HasValue.ValueChangeEvent ce = new HasValue.ValueChangeEvent((Component)this, null, true);
                this.listeners.values().forEach(l -> l.valueChange(ce));
            }
        });
        v.addComponent((Component)this.upload);
        v.addComponent((Component)this.url);
        this.hyperLink.setTargetName("_blank");
        this.setCompositionRoot((Component)h);
        this.upload.addChangeListener((Upload.ChangeListener & Serializable)e -> System.out.println("UPLOAD HA CAMBIADO!"));
    }

    public void setValue(IResource o) {
        this.file = o;
        try {
            boolean esFoto = false;
            if (this.file != null && FileType.URL.equals((Object)this.file.getType()) && this.file.getUrl() != null && (this.file.getUrl().toLowerCase().contains("githubusercontent") || this.file.getUrl().toLowerCase().contains("googleusercontent"))) {
                esFoto = true;
            }
            if (esFoto || this.file != null && this.file.getName() != null && (this.file.getName().toLowerCase().endsWith(".jpg") || this.file.getName().toLowerCase().endsWith(".jpeg") || this.file.getName().toLowerCase().endsWith(".gif") || this.file.getName().toLowerCase().endsWith(".png") || this.file.getName().toLowerCase().endsWith(".svg") || this.file.getName().toLowerCase().endsWith(".webp"))) {
                this.hyperLink.setVisible(false);
                this.image.setVisible(true);
                String u = this.file.toFileLocator().getUrl();
                this.image.setSource((Resource)(!Strings.isNullOrEmpty((String)u) ? new ExternalResource(u) : new ClassResource("/images/noimage.png")));
            } else {
                this.hyperLink.setCaption(this.file != null ? this.file.getName() : null);
                if (this.file != null && this.file.getName() != null) {
                    this.hyperLink.setResource((Resource)(this.file != null && this.file.toFileLocator().getUrl() != null ? new ExternalResource(this.file.toFileLocator().getUrl()) : new ClassResource("/images/noimage.png")));
                }
                this.hyperLink.setVisible(true);
                this.image.setVisible(false);
            }
            if (this.file != null && this.file.toFileLocator().getUrl() != null && !"".equals(this.file.toFileLocator().getUrl())) {
                this.cb.setValue((Object)this.file.getType());
                this.url.setValue(this.file.getUrl() != null ? this.file.getUrl() : "");
            } else {
                this.image.setVisible(true);
                this.hyperLink.setVisible(false);
                this.image.setSource((Resource)new ClassResource("/images/noimage.png"));
            }
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
        }
        this.upload.setComponentError(null);
    }

    public IResource getValue() {
        return this.file;
    }

    public void setRequiredIndicatorVisible(boolean b) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setReadOnly(boolean b) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<IResource> valueChangeListener) {
        final UUID _id = UUID.randomUUID();
        this.listeners.put(_id, valueChangeListener);
        return new Registration(){
            UUID id;
            {
                this.id = _id;
            }

            public void remove() {
                ResourceComponent.this.listeners.remove(this.id);
            }
        };
    }

    public void focus() {
        this.upload.focus();
    }

    public int getTabIndex() {
        return this.upload.getTabIndex();
    }

    public void setTabIndex(int i) {
        this.upload.setTabIndex(i);
    }
}

