/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.components.views;

import com.google.common.collect.Iterables;
import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.MDDRunnableAction;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.vaadin.components.ClassOption;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ResourceModel;
import io.mateu.mdd.vaadin.data.MDDBinder;
import io.mateu.mdd.vaadin.util.VaadinHelper;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnedCollectionComponent
extends EditorViewComponent {
    private static final Logger log = LoggerFactory.getLogger(OwnedCollectionComponent.class);
    private final MDDBinder parentBinder;
    private final FieldInterfaced field;
    private Collection collection;
    private int currentIndex = 0;

    @Override
    public VaadinIcons getIcon() {
        return VaadinIcons.LIST_SELECT;
    }

    @Override
    public boolean beforeBack() {
        if (!this.validate()) {
            return false;
        }
        Object bean = this.getParentBinder().getBean();
        try {
            ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)bean, (Object)this.collection);
            this.getParentBinder().setBean(bean, false);
        }
        catch (Exception e) {
            Notifier.alert((Throwable)e);
            return false;
        }
        return true;
    }

    public MDDBinder getParentBinder() {
        return this.parentBinder;
    }

    @Override
    public List<AbstractAction> getActions() {
        ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
        if (this.field != null) {
            if (!this.isActionPresent("col_prev")) {
                l.add(new MDDRunnableAction(""){

                    public void run() {
                        if (OwnedCollectionComponent.this.validate()) {
                            if (OwnedCollectionComponent.this.currentIndex > 0) {
                                try {
                                    OwnedCollectionComponent.this.setIndex(OwnedCollectionComponent.this.currentIndex - 1);
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            } else {
                                Notifier.info((String)"This was already the first item of the list");
                            }
                        }
                    }
                }.setIcon(VaadinIcons.ARROW_UP).setId("col_prev"));
            } else {
                this.getMenuItemById("col_prev").setVisible(true);
            }
            if (!this.isActionPresent("col_next")) {
                l.add(new MDDRunnableAction(""){

                    public void run() {
                        if (OwnedCollectionComponent.this.validate()) {
                            if (OwnedCollectionComponent.this.collection != null && OwnedCollectionComponent.this.currentIndex < OwnedCollectionComponent.this.collection.size() - 1) {
                                try {
                                    OwnedCollectionComponent.this.setIndex(OwnedCollectionComponent.this.currentIndex + 1);
                                }
                                catch (Exception e1) {
                                    Notifier.alert((Throwable)e1);
                                }
                            } else {
                                Notifier.info((String)"This was already the last item of the list");
                            }
                        }
                    }
                }.setIcon(VaadinIcons.ARROW_DOWN).setId("col_next"));
            } else {
                this.getMenuItemById("col_next").setVisible(true);
            }
            if (ReflectionHelper.puedeAnadir((FieldInterfaced)this.field)) {
                if (!this.isActionPresent("col_add")) {
                    l.add(new MDDRunnableAction("Add"){

                        public void run() {
                            if (OwnedCollectionComponent.this.validate()) {
                                try {
                                    OwnedCollectionComponent.this.setIndex(OwnedCollectionComponent.this.collection.size());
                                }
                                catch (Throwable throwable) {
                                    Notifier.alert((Throwable)throwable);
                                }
                            }
                        }
                    }.setIcon(VaadinIcons.PLUS).setId("col_add"));
                } else {
                    this.getMenuItemById("col_add").setVisible(true);
                }
            }
            if (ReflectionHelper.puedeBorrar((FieldInterfaced)this.field)) {
                if (!this.isActionPresent("col_remove")) {
                    l.add(new MDDRunnableAction("Remove"){

                        public void run() {
                            if (OwnedCollectionComponent.this.currentIndex >= 0 && OwnedCollectionComponent.this.currentIndex < OwnedCollectionComponent.this.collection.size()) {
                                VaadinHelper.confirm("Are you sure you want to delete this item?", () -> {
                                    block7: {
                                        try {
                                            Object m = OwnedCollectionComponent.this.getModel();
                                            if (m != null && m instanceof ResourceModel) {
                                                m = ((ResourceModel)m).getResource();
                                            }
                                            Object parentBean = OwnedCollectionComponent.this.parentBinder.getBean();
                                            OwnedCollectionComponent.this.collection = ReflectionHelper.remove((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)OwnedCollectionComponent.this.field, (Object)parentBean)), (Object)m);
                                            ReflectionHelper.setValue((FieldInterfaced)OwnedCollectionComponent.this.field, (Object)parentBean, (Object)OwnedCollectionComponent.this.collection);
                                            OwnedCollectionComponent.this.parentBinder.setBean(parentBean, false);
                                            try {
                                                if (OwnedCollectionComponent.this.collection.size() == 0) {
                                                    MDDUIAccessor.goBack();
                                                    break block7;
                                                }
                                                if (OwnedCollectionComponent.this.currentIndex == OwnedCollectionComponent.this.collection.size()) {
                                                    OwnedCollectionComponent.this.setIndex(OwnedCollectionComponent.this.collection.size() - 1);
                                                    break block7;
                                                }
                                                OwnedCollectionComponent.this.setIndex(OwnedCollectionComponent.this.currentIndex);
                                            }
                                            catch (Throwable throwable) {
                                                Notifier.alert((Throwable)throwable);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Notifier.alert((Throwable)throwable);
                                        }
                                    }
                                });
                            } else {
                                Notifier.info((String)"Can not remove this item");
                            }
                        }
                    }.setIcon(VaadinIcons.MINUS).setId("col_remove"));
                } else {
                    this.getMenuItemById("col_remove").setVisible(true);
                }
            }
            if (ReflectionHelper.puedeAnadir((FieldInterfaced)this.field)) {
                if (!this.isActionPresent("col_copy")) {
                    l.add(new MDDRunnableAction("Copy prev"){

                        public void run() {
                            try {
                                if (OwnedCollectionComponent.this.currentIndex > 0) {
                                    OwnedCollectionComponent.this.getElementAt(OwnedCollectionComponent.this.currentIndex, v0 -> {
                                        try {
                                            OwnedCollectionComponent.this.getElementAt(OwnedCollectionComponent.this.currentIndex - 1, v -> {
                                                ReflectionHelper.copy((Object)v, (Object)v0);
                                                OwnedCollectionComponent.this.getBinder().update(v0);
                                            });
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                    });
                                } else {
                                    Notifier.info((String)"This is the first item of the list. Can not copy from previous");
                                }
                            }
                            catch (Throwable throwable) {
                                Notifier.alert((Throwable)throwable);
                            }
                        }
                    }.setIcon(VaadinIcons.COPY).setId("col_copy"));
                } else {
                    this.getMenuItemById("col_copy").setVisible(true);
                }
            }
            l.addAll(super.getActions());
        }
        return l;
    }

    @Override
    protected void removeUneditableFields(List<FieldInterfaced> fields) {
        super.removeUneditableFields(fields);
        if (this.field != null) {
            fields.removeIf(f -> {
                OneToMany a = (OneToMany)this.field.getAnnotation(OneToMany.class);
                return a != null && f.getName().equals(a.mappedBy());
            });
        }
    }

    public OwnedCollectionComponent(MDDBinder parentBinder, FieldInterfaced field, int index) throws Exception {
        super(field.getGenericClass());
        this.parentBinder = parentBinder;
        this.field = field;
        this.collection = (Collection)ReflectionHelper.getValue((FieldInterfaced)field, (Object)parentBinder.getBean());
        if (index < 0) {
            this.setIndex(this.collection.size());
        } else {
            this.getElementAt(index, v -> {
                try {
                    this.setElement(v, index);
                }
                catch (Exception e) {
                    Notifier.alert((Throwable)e);
                }
            });
        }
    }

    private void setElement(Object value, int index) throws Exception {
        this.currentIndex = index;
        this.setModel(value);
        if (this.getParent() != null) {
            MDDUIAccessor.updateTitle((String)this.toString());
        }
    }

    @Override
    public void onGoBack() {
        if (this.parentBinder != null) {
            try {
                Object o = this.parentBinder.getBean();
                ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)o, (Object)this.collection);
                this.parentBinder.update(o);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
    }

    @Override
    public String toString() {
        String s = "";
        Object b = this.parentBinder != null ? this.parentBinder.getBean() : null;
        s = s + (b != null ? b : "---");
        s = s + ": ";
        s = this.currentIndex < this.collection.size() ? s + Helper.capitalize((String)(this.field.getName() + " " + (this.currentIndex + 1) + " of " + this.collection.size())) : s + Helper.capitalize((String)("New " + this.field.getName()));
        return s;
    }

    public void setIndex(int index) throws Exception {
        this.getElementAt(index, v -> {
            try {
                this.setElement(v, index);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        });
    }

    private void getElementAt(int index, Consumer consumer) throws Exception {
        block16: {
            Object v = null;
            if (index == this.collection.size()) {
                Set subClasses = ReflectionHelper.getSubclasses((Class)ReflectionHelper.getGenericClass((Type)this.field.getGenericType()));
                Class c = null;
                if (subClasses.size() > 1) {
                    LinkedHashSet subClassesOptions = new LinkedHashSet();
                    subClasses.forEach(cl -> subClassesOptions.add(new ClassOption((Class)cl)));
                    VaadinHelper.choose("Please choose type", subClassesOptions, cl -> {
                        try {
                            Object o = this.newInstance(((ClassOption)cl).get_class());
                            Object parentBean = this.parentBinder.getBean();
                            this.collection = ReflectionHelper.extend((Collection)((Collection)ReflectionHelper.getValue((FieldInterfaced)this.field, (Object)parentBean)), (Object)o);
                            ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)parentBean, (Object)this.collection);
                            this.parentBinder.setBean(parentBean, false);
                            consumer.accept(o);
                        }
                        catch (Exception e) {
                            Notifier.alert((Throwable)e);
                        }
                    }, () -> MDDUIAccessor.goBack());
                } else {
                    c = subClasses.size() == 1 ? (Class)subClasses.iterator().next() : ReflectionHelper.getGenericClass((Type)this.field.getGenericType());
                }
                if (c != null) {
                    try {
                        Constructor con = ReflectionHelper.getConstructor((Class)c, (Class)this.parentBinder.getBeanType());
                        if (con == null) {
                            con = c.getConstructor(new Class[0]);
                        }
                        if (con != null && Modifier.isPublic(con.getModifiers())) {
                            try {
                                Object parentBean = this.parentBinder.getBean();
                                this.collection = ReflectionHelper.addToCollection((FieldInterfaced)this.field, (Object)this.parentBinder.getBean());
                                ReflectionHelper.setValue((FieldInterfaced)this.field, (Object)parentBean, (Object)this.collection);
                                this.parentBinder.setBean(parentBean, false);
                                Object i2 = Iterables.getLast((Iterable)this.collection);
                                consumer.accept(i2);
                            }
                            catch (Exception ex) {
                                Notifier.alert((Throwable)ex);
                            }
                            break block16;
                        }
                        con = ReflectionHelper.getConstructor((Class)c);
                        if (con != null) {
                            VaadinHelper.fill("I need some data", con, i -> {
                                try {
                                    this.collection = ReflectionHelper.addToCollection((FieldInterfaced)this.field, (Object)this.parentBinder.getBean());
                                    consumer.accept(i);
                                }
                                catch (Exception ex) {
                                    Notifier.alert((Throwable)ex);
                                }
                            }, () -> MDDUIAccessor.goBack());
                            break block16;
                        }
                        Notifier.alert((String)("No constructor found for " + c.getSimpleName()));
                    }
                    catch (NoSuchMethodException ex) {
                        Notifier.alert((Throwable)ex);
                    }
                }
            } else {
                if (this.collection instanceof List) {
                    v = ((List)this.collection).get(index);
                } else if (this.collection instanceof Collection) {
                    int pos = 0;
                    for (Object o : this.collection) {
                        if (pos++ != index) continue;
                        v = o;
                        break;
                    }
                }
                consumer.accept(v);
            }
        }
    }

    private Object newInstance(Class c) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object parent = this.parentBinder.getBean();
        Method m = ReflectionHelper.getMethod(parent.getClass(), (String)("create" + ReflectionHelper.getFirstUpper((String)this.field.getName()) + "Instance"));
        Object i = null;
        if (m != null) {
            i = m.invoke(parent, new Object[0]);
        } else {
            i = ReflectionHelper.newInstance((Class)c, (Object)parent);
            for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)c)) {
                if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                ReflectionHelper.setValue((FieldInterfaced)f, (Object)i, (Object)parent);
                break;
            }
        }
        return i;
    }
}

