/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.controllers.firstLevel;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.MDDOpenHtml;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.actions.AcctionRunner;
import io.mateu.mdd.vaadin.components.HomeComponent;
import io.mateu.mdd.vaadin.components.app.views.firstLevel.AreaComponent;
import io.mateu.mdd.vaadin.controllers.BrokenLinkController;
import io.mateu.mdd.vaadin.controllers.Controller;
import io.mateu.mdd.vaadin.controllers.firstLevel.ModuleController;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.util.notification.Notifier;

public class AreaController
extends Controller {
    private final AbstractArea area;

    public AreaController(ViewStack stack, String path, AbstractArea area) {
        AbstractAction home;
        this.area = area;
        if (MateuUI.get() != null) {
            MateuUI.get().setArea(area);
        }
        if ((home = area.getDefaultAction()) != null) {
            if (home instanceof MDDOpenHtml) {
                this.register(stack, path, (Component)new HomeComponent(home.getIcon(), "" + area.getName(), (Component)new Label(((MDDOpenHtml)home).html, ContentMode.HTML), false));
            } else {
                try {
                    new AcctionRunner().run(home);
                }
                catch (Throwable e) {
                    Notifier.alert((Throwable)e);
                }
            }
        } else {
            this.register(stack, path, (Component)new AreaComponent(area));
        }
    }

    @Override
    public void apply(ViewStack stack, String path, String step, String cleanStep, String remaining) throws Throwable {
        if (!"".equals(step)) {
            App app = MDDUIAccessor.getApp();
            IModule m = app.getModule(path + "/" + step);
            Controller controller = null;
            controller = m != null ? new ModuleController(stack, path + "/" + step, m) : new BrokenLinkController(stack, path + "/" + step);
            controller.next(stack, path, step, remaining);
        }
    }
}

