/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.navigation;

import com.google.common.base.Strings;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.ui.UI;
import io.mateu.mdd.core.interfaces.WizardPage;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.vaadin.MateuUI;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.components.views.EditorViewComponent;
import io.mateu.mdd.vaadin.components.views.ListViewComponent;
import io.mateu.mdd.vaadin.controllers.Controller;
import io.mateu.mdd.vaadin.controllers.firstLevel.HomeController;
import io.mateu.mdd.vaadin.controllers.secondLevel.EditorController;
import io.mateu.mdd.vaadin.controllers.secondLevel.WizardController;
import io.mateu.mdd.vaadin.navigation.View;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;

public class MateuViewProvider
implements ViewProvider {
    private final ViewStack stack;
    private String lastState;
    private com.vaadin.navigator.View lastView;
    private int firstViewInWindow;
    private EditorViewComponent currentEditor;

    public MateuViewProvider(ViewStack stack) {
        this.stack = stack;
    }

    public void setLastView(com.vaadin.navigator.View lastView) {
        this.lastView = lastView;
        this.lastState = this.stack.getState(this.stack.getLast());
    }

    public String getViewName(String s) {
        return s;
    }

    public com.vaadin.navigator.View getView(String s) {
        AbstractViewComponent c;
        String appPrefix = MDDUIAccessor.getUiRootPath();
        if (!"".equals(appPrefix)) {
            if (appPrefix.startsWith("/")) {
                appPrefix = appPrefix.substring(1);
            }
            if (!appPrefix.endsWith("/")) {
                appPrefix = appPrefix + "/";
            }
        }
        if (s.startsWith(appPrefix)) {
            s = s.substring(appPrefix.length());
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (s.equals(this.lastState)) {
            return this.lastView;
        }
        this.currentEditor = null;
        Controller controller = null;
        View v = null;
        String aux = s;
        String remaining = "";
        while (!Strings.isNullOrEmpty((String)aux) && v == null) {
            if (this.stack.get(aux) != null) {
                v = (View)this.stack.popTo(aux);
            }
            if (v != null || Strings.isNullOrEmpty((String)aux) || !aux.contains("/")) continue;
            remaining = aux.substring(aux.lastIndexOf("/")) + remaining;
            aux = aux.substring(0, aux.lastIndexOf("/"));
        }
        if (Strings.isNullOrEmpty((String)aux)) {
            this.stack.clear();
        }
        App app = MDDUIAccessor.getApp();
        if (v != null) {
            controller = v.getController();
            v = null;
        } else {
            Controller controller2 = WizardPage.class.isAssignableFrom(app.getBean().getClass()) ? new WizardController(this.stack, "", (WizardPage)app.getBean()) : (controller = app.isForm() ? new EditorController(this.stack, "", app.getBean()) : new HomeController(this.stack));
        }
        if (v == null) {
            try {
                if (aux.startsWith("/")) {
                    aux = aux.substring(1);
                }
                if (remaining.startsWith("/")) {
                    remaining = remaining.substring(1);
                }
                String step = remaining;
                remaining = "";
                if (step.contains("/")) {
                    remaining = step.substring(step.indexOf("/") + 1);
                    step = step.substring(0, step.indexOf("/"));
                }
                String cleanStep = ViewStack.cleanState(step);
                controller.apply(this.stack, aux, step, cleanStep, remaining);
            }
            catch (Throwable e) {
                Notifier.alert((Throwable)e);
            }
            v = this.stack.getLast();
        }
        if (this.firstViewInWindow > 0 && this.stack.size() < this.firstViewInWindow) {
            this.firstViewInWindow = 0;
            UI.getCurrent().getWindows().forEach(w -> {
                w.setData((Object)"noback");
                w.close();
            });
        }
        if ((c = v.getViewComponent()) != null && c instanceof AbstractViewComponent) {
            c.buildIfNeeded();
        }
        if (c.getStyleName().contains("refreshOnBack")) {
            if (c != null && c instanceof EditorViewComponent) {
                EditorViewComponent evc = (EditorViewComponent)c;
                Object id = ReflectionHelper.getId((Object)evc.getModel());
                if (id != null) {
                    try {
                        evc.load(id);
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                    }
                } else {
                    evc.updateModel(evc.getModel());
                }
            }
            c.removeStyleName("refreshOnBack");
        }
        if (c != null && c instanceof AbstractViewComponent) {
            c.updatePageTitle();
        }
        if (c != null && c instanceof ListViewComponent && ((ListViewComponent)c).resultsComponent != null) {
            ((ListViewComponent)c).resultsComponent.getGrid().getSelectionModel().deselectAll();
        }
        if (c != null && c instanceof EditorViewComponent) {
            this.currentEditor = (EditorViewComponent)c;
            if (this.firstViewInWindow == 0) {
                this.firstViewInWindow = this.stack.size() + 1;
            }
        }
        this.lastState = s;
        this.lastView = v;
        if (v != null && this.firstViewInWindow > 0 && this.stack.size() >= this.firstViewInWindow && MateuUI.get() != null) {
            v.setOpenNewWindow(true);
            MateuUI.get().openInWindow(v);
            if (v != null && v.getViewComponent() != null && v.getViewComponent() instanceof EditorViewComponent && ((EditorViewComponent)v.getViewComponent()).getBeforeOpen() != null) {
                ((EditorViewComponent)v.getViewComponent()).getBeforeOpen().run();
            }
            return null;
        }
        if (v != null && v.getViewComponent() != null && v.getViewComponent() instanceof EditorViewComponent && ((EditorViewComponent)v.getViewComponent()).getBeforeOpen() != null) {
            ((EditorViewComponent)v.getViewComponent()).getBeforeOpen().run();
        }
        if (v != null && v.getViewComponent() != null && UI.getCurrent() != null && v.getViewComponent().getPageTitle() != null) {
            UI.getCurrent().getPage().setTitle(v.getViewComponent().getPageTitle() != null ? v.getViewComponent().getPageTitle() : "No title");
        }
        return v != null && v.getWindowContainer() == null ? v : null;
    }

    public ViewStack getStack() {
        return this.stack;
    }

    public EditorViewComponent getCurrentEditor() {
        return this.currentEditor;
    }

    public void setCurrentEditor(EditorViewComponent currentEditor) {
        this.currentEditor = currentEditor;
    }
}

