/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.navigation;

import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import io.mateu.mdd.vaadin.components.ComponentWrapper;
import io.mateu.mdd.vaadin.components.views.AbstractViewComponent;
import io.mateu.mdd.vaadin.controllers.Controller;
import io.mateu.mdd.vaadin.navigation.ViewStack;
import java.util.Objects;
import java.util.UUID;

public class View
implements com.vaadin.navigator.View {
    private String uuid = UUID.randomUUID().toString();
    private Controller controller;
    private final AbstractViewComponent viewComponent;
    private final ViewStack stack;
    private final Component component;
    private Window windowContainer;
    private boolean openNewWindow;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return this.uuid.equals(view.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public View(ViewStack stack, Component component) {
        this.stack = stack;
        this.component = component;
        this.viewComponent = component instanceof AbstractViewComponent ? (AbstractViewComponent)component : this.wrapComponent(null, component);
        if (component instanceof AbstractViewComponent) {
            ((AbstractViewComponent)component).setView(this);
            ((AbstractViewComponent)component).setStack(stack);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public AbstractViewComponent getViewComponent() {
        return this.viewComponent;
    }

    public Component getComponent() {
        return this.component;
    }

    public String toString() {
        return ((Object)((Object)this.viewComponent)).toString();
    }

    private AbstractViewComponent wrapComponent(String title, Component component) {
        return new ComponentWrapper(title, component);
    }

    public void updateViewTitle(String newTitle) {
        this.viewComponent.updateViewTitle(newTitle);
    }

    public void setWindowContainer(Window w) {
        int posx;
        this.windowContainer = w;
        if (w != null && (posx = this.stack.indexOf(this)) > 0 && !w.equals((Object)this.stack.get(posx - 1).getWindowContainer())) {
            this.viewComponent.setBackable(false);
        }
    }

    public Window getWindowContainer() {
        return this.windowContainer;
    }

    public void setOpenNewWindow(boolean openNewWindow) {
        this.openNewWindow = openNewWindow;
    }

    public boolean isOpenNewWindow() {
        return this.openNewWindow;
    }

    public void setController(Controller c) {
        this.controller = c;
    }
}

