/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.vaadin.pojos;

import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.NonDuplicable;
import io.mateu.mdd.shared.annotations.Password;
import io.mateu.mdd.shared.data.URLResource;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.interfaces.UserPrincipal;
import io.mateu.util.Helper;
import io.mateu.util.interfaces.GeneralRepository;
import java.io.IOException;
import javax.validation.constraints.NotNull;

@NonDuplicable
public class Profile
implements PersistentPojo {
    private IResource photo;
    private String name;
    private String email;

    @Action(value="Change password")
    public void changePassword(@NotNull @Password String currentPassword, @NotNull @Password String newPassword, @NotNull @Password String newPasswordAgain) throws Throwable {
        if (!newPassword.equals(newPasswordAgain)) {
            throw new Exception("New password fieldBuilders must be equal");
        }
        GeneralRepository repo = (GeneralRepository)Helper.getImpl(GeneralRepository.class);
        repo.changePassword(MDDUIAccessor.getCurrentUser().getLogin(), currentPassword, newPassword);
    }

    public void save() throws IOException, Throwable {
        GeneralRepository repo = (GeneralRepository)Helper.getImpl(GeneralRepository.class);
        repo.updateUser(MDDUIAccessor.getCurrentUser().getLogin(), this.getName(), this.getEmail(), this.getPhoto());
    }

    public void load(Object id) throws Throwable {
        UserPrincipal u = MDDUIAccessor.getCurrentUser();
        this.setName(u.getName());
        this.setEmail(u.getEmail());
        this.setPhoto((IResource)(u.getPhoto() != null ? new URLResource(u.getPhoto()) : null));
    }

    public Object getId() {
        return MDDUIAccessor.getCurrentUser().getLogin();
    }

    public String toString() {
        return "Profile for user " + (MDDUIAccessor.getCurrentUserLogin() != null ? MDDUIAccessor.getCurrentUserLogin() : "unknown");
    }

    public IResource getPhoto() {
        return this.photo;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setPhoto(IResource photo) {
        this.photo = photo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

