/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.file;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import io.memoria.jutils.adapter.yaml.YamlMap;
import io.memoria.jutils.core.file.FileReader;
import io.memoria.jutils.core.yaml.Yaml;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public record LocalFileReader(Scheduler scheduler) implements FileReader
{
    public Mono<String> file(Path path) {
        return this.lines(path).reduce((a, b) -> a + "\n" + b);
    }

    public Flux<String> lines(Path path) {
        try {
            return Flux.fromStream(Files.lines(path)).subscribeOn(this.scheduler);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public Mono<Yaml> yaml(Path path) {
        return this.lines(path).flatMap(l -> this.yamlInclude((String)l, path)).reduce((a, b) -> a + "\n" + b).map(LocalFileReader::yamlReader).flatMap(yamlReader -> Mono.fromCallable(() -> (MapInstance)yamlReader.read(MapInstance.class))).map(YamlMap::new);
    }

    private Flux<String> yamlInclude(String line, Path relativePath) {
        if (line.startsWith("include:")) {
            String path = line.split(":")[1].trim();
            return this.lines(relativePath.getParent().resolve(path));
        }
        return Flux.just((Object)line);
    }

    private static YamlReader yamlReader(String s) {
        YamlConfig yc = new YamlConfig();
        yc.readConfig.setIgnoreUnknownProperties(true);
        return new YamlReader(s, yc);
    }

    private static final class MapInstance
    extends HashMap<String, Object> {
        private MapInstance() {
        }
    }
}

