/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.generator;

import io.memoria.jutils.core.generator.StringGenerator;
import java.util.Random;

public record RandomStringGenerator(Random random) implements StringGenerator
{
    public static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public String alphanumeric(int length) {
        StringBuilder sb = new StringBuilder(length);
        while (sb.length() < length) {
            sb.append(ALPHANUMERIC.charAt(this.random.nextInt(ALPHANUMERIC.length())));
        }
        return sb.toString();
    }

    public String hex(int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(this.random.nextInt()));
        }
        return sb.substring(0, length);
    }

    public String minMaxAlphanumeric(int min, int max) {
        return this.alphanumeric(this.random.nextInt(max - min) + min);
    }

    public String minMaxHex(int min, int max) {
        return this.hex(this.random.nextInt(max - min) + min);
    }
}

