/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import io.memoria.jutils.core.dto.DTO;
import io.memoria.jutils.core.json.Json;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;

public record JsonGson(Gson gson) implements Json
{
    public JsonGson(TypeAdapter<?> ... typeAdapters) {
        this(new GsonBuilder(), typeAdapters);
    }

    public JsonGson(GsonBuilder gsonBuilder, TypeAdapter<?> ... typeAdapters) {
        this(JsonGson.create(gsonBuilder, typeAdapters));
    }

    public <T> Try<T> deserialize(String str, Type type) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.gson.fromJson(str, type));
    }

    public <T> Try<T> deserialize(String str, Class<T> tClass) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.gson.fromJson(str, tClass));
    }

    public <T> Try<T> deserializeByDTO(String str, Class<? extends DTO<T>> tClass) {
        return Try.of((CheckedFunction0 & Serializable)() -> (Try)((DTO)this.gson.fromJson(str, tClass)).get()).flatMap(Function.identity());
    }

    public <T> String serialize(T t) {
        return this.gson.toJson(t);
    }

    private static Gson create(GsonBuilder gsonBuilder, TypeAdapter<?> ... typeAdapters) {
        for (TypeAdapter<?> t : typeAdapters) {
            ParameterizedType paramType = (ParameterizedType)t.getClass().getGenericSuperclass();
            Type tClass = paramType.getActualTypeArguments()[0];
            gsonBuilder.registerTypeHierarchyAdapter((Class)tClass, t);
        }
        return gsonBuilder.create();
    }
}

