/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.memoria.jutils.core.json.JsonException;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Traversable;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;

public class JsonGsonUtils {
    public static <T> Try<T> deserialize(JsonReader in, Map<String, TypeAdapter<? extends T>> mappers) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            in.beginObject();
            Object obj = null;
            if (in.hasNext()) {
                String nextName = in.nextName();
                obj = ((TypeAdapter)mappers.get((Object)nextName).getOrElseThrow(() -> JsonException.noMatchingAdapter((String)nextName))).read(in);
            }
            in.endObject();
            return obj;
        });
    }

    public static <T> Try<List<T>> deserializeAsList(JsonReader in, TypeAdapter<T> typeAdapter) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            List list = List.empty();
            in.beginArray();
            while (in.hasNext()) {
                list = list.append(typeAdapter.read(in));
            }
            in.endArray();
            return list;
        });
    }

    public static <T> Try<List<T>> deserializeAsList(JsonReader in, CheckedFunction1<JsonReader, T> reader) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            in.beginArray();
            List list = List.empty();
            while (in.hasNext()) {
                list = list.append(reader.apply((Object)in));
            }
            in.endArray();
            return list;
        });
    }

    public static <E extends T, T> void serialize(JsonWriter out, TypeAdapter<T> typeAdapter, Traversable<E> traversable) throws IOException {
        out.beginArray();
        for (Object t : traversable) {
            typeAdapter.write(out, t);
        }
        out.endArray();
    }

    public static void serialize(JsonWriter out, Traversable<String> traversable) throws IOException {
        out.beginArray();
        for (String t : traversable) {
            out.value(t);
        }
        out.endArray();
    }

    public static <T extends Number> void serializeNumber(JsonWriter out, Traversable<T> traversable) throws IOException {
        out.beginArray();
        for (Number t : traversable) {
            out.value(t.toString());
        }
        out.endArray();
    }

    private JsonGsonUtils() {
    }
}

