/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class TimeAdapter
extends TypeAdapter<LocalTime> {
    private final DateTimeFormatter dateTimeFormat;
    private final ZoneOffset zoneOffset;

    public TimeAdapter(DateTimeFormatter dateTimeFormat, ZoneOffset zoneOffset) {
        this.dateTimeFormat = dateTimeFormat;
        this.zoneOffset = zoneOffset;
    }

    public LocalTime read(JsonReader in) throws IOException {
        return LocalTime.parse(in.nextString(), this.dateTimeFormat).atOffset(this.zoneOffset).toLocalTime();
    }

    public void write(JsonWriter out, LocalTime localTime) throws IOException {
        out.value(localTime.atOffset(this.zoneOffset).format(this.dateTimeFormat));
    }
}

