/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.adapter.yaml;

import io.memoria.jutils.core.yaml.Yaml;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.Map;

public record YamlMap(io.vavr.collection.Map<String, Object> map) implements Yaml
{
    public YamlMap(Map<String, Object> conf) {
        this((io.vavr.collection.Map<String, Object>)HashMap.ofAll(conf));
    }

    public Option<Boolean> asBoolean(String key) {
        return this.asString(key).map(Boolean::parseBoolean);
    }

    public Option<List<Boolean>> asBooleanList(String key) {
        return this.asStringList(key).map(l -> l.map(Boolean::parseBoolean));
    }

    public Option<Double> asDouble(String key) {
        return this.asString(key).map(Double::parseDouble);
    }

    public Option<List<Double>> asDoubleList(String key) {
        return this.asStringList(key).map(o -> o.map(Double::parseDouble));
    }

    public Option<Integer> asInteger(String key) {
        return this.asString(key).map(Integer::parseInt);
    }

    public Option<List<Integer>> asIntegerList(String key) {
        return this.asStringList(key).map(o -> o.map(Integer::parseInt));
    }

    public Option<Long> asLong(String key) {
        return this.asString(key).map(Long::parseLong);
    }

    public Option<List<Long>> asLongList(String key) {
        return this.asStringList(key).map(o -> o.map(Long::parseLong));
    }

    public Option<String> asString(String key) {
        return this.map.get((Object)key).map(s -> (String)s);
    }

    public Option<List<String>> asStringList(String key) {
        return this.map.get((Object)key).flatMap(m -> {
            if (m instanceof java.util.List) {
                return Option.some((Object)List.ofAll((Iterable)((java.util.List)m)));
            }
            return Option.none();
        });
    }

    public Option<Yaml> asYaml(String key) {
        return this.map.get((Object)key).flatMap(m -> {
            if (m instanceof Map) {
                return Option.some((Object)new YamlMap((Map)m));
            }
            return Option.none();
        });
    }
}

