/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.messaging.adapter.pulsar;

import io.memoria.jutils.core.messaging.Message;
import io.memoria.jutils.core.messaging.MsgReceiver;
import io.vavr.control.Option;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public record PulsarReceiver(Consumer<String> consumer, Duration frequency) implements MsgReceiver
{
    public Flux<Message> get() {
        return Flux.interval((Duration)this.frequency).concatMap(i -> this.consume());
    }

    private Mono<Message> consume() {
        return Mono.fromFuture((CompletableFuture)this.consumer.receiveAsync()).map(this::toMessage);
    }

    private Message toMessage(org.apache.pulsar.client.api.Message<String> m) {
        Option id = m.getSequenceId() != -1L ? Option.some((Object)m.getSequenceId()) : Option.none();
        return new Message((String)m.getValue(), id);
    }
}

