/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.messaging.adapter.pulsar;

import io.memoria.jutils.core.messaging.Message;
import io.memoria.jutils.core.messaging.MsgSender;
import io.memoria.jutils.core.messaging.Response;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.MessageIdImpl;
import reactor.core.publisher.Mono;

public record PulsarSender(Producer<String> producer) implements MsgSender
{
    public Mono<Response> apply(Message message) {
        TypedMessageBuilder pm = this.producer.newMessage();
        if (message.id().isDefined()) {
            pm = pm.sequenceId(((Long)message.id().get()).longValue());
        }
        return Mono.fromFuture((CompletableFuture)pm.value((Object)message.value()).sendAsync()).map(this::toResponse);
    }

    private Response toResponse(MessageId id) {
        long entry = ((MessageIdImpl)id).getEntryId();
        String ledger = String.valueOf(((MessageIdImpl)id).getLedgerId());
        String partition = String.valueOf(((MessageIdImpl)id).getPartitionIndex());
        return new Response(Option.some((Object)entry), Option.none(), (Map)HashMap.of((Object)"ledgerId", (Object)ledger, (Object)"partition", (Object)partition));
    }
}

