/*
 * Decompiled with CFR 0.152.
 */
package io.memoria.jutils.messaging.adapter.pulsar;

import io.memoria.jutils.core.messaging.MessageFilter;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;

public class PulsarUtils {
    public static Consumer<String> createConsumer(PulsarClient client, MessageFilter mf) throws PulsarClientException {
        Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{mf.topic()}).subscriptionName(mf.topic() + "subscription").subscribe();
        consumer.seek(mf.offset());
        return consumer;
    }

    public static Producer<String> createProducer(PulsarClient client, MessageFilter mf) throws PulsarClientException {
        return client.newProducer(Schema.STRING).topic(mf.topic()).create();
    }

    public static PulsarClient pulsarClient(String serviceUrl) throws PulsarClientException {
        return PulsarClient.builder().serviceUrl(serviceUrl).build();
    }

    private PulsarUtils() {
    }
}

