/*
 * Decompiled with CFR 0.152.
 */
package io.mockbox.core.http.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mockbox.core.http.HttpMethod;
import io.mockbox.core.http.handler.HttpHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public final class HttpJsonHandler
implements HttpHandler {
    private final HttpMethod method;
    private final String uri;
    private final int statusCode;
    private final Object jsonResponse;
    private final ObjectMapper objectMapper;

    public HttpJsonHandler(HttpMethod method, String uri, int statusCode, Object jsonResponse) {
        this.method = method;
        this.uri = uri;
        this.statusCode = statusCode;
        this.jsonResponse = jsonResponse;
        this.objectMapper = new ObjectMapper();
    }

    public HttpJsonHandler(HttpMethod method, String uri, Object jsonResponse) {
        this(method, uri, 200, jsonResponse);
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> handle() {
        return (request, response) -> {
            try {
                return response.status(this.statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON).sendString((Publisher)Mono.just((Object)this.objectMapper.writeValueAsString(this.jsonResponse)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

