/*
 * Decompiled with CFR 0.152.
 */
package io.mockbox.core.http;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.server.HttpServerRequest;
import reactor.util.annotation.Nullable;

final class HttpPatchMethodPredicate
implements Predicate<HttpServerRequest>,
Function<Object, Map<String, String>> {
    final HttpVersion protocol;
    final HttpMethod method;
    final String uri;
    final UriPathTemplate template;

    private static Predicate<HttpServerRequest> http(String uri, HttpVersion protocol, HttpMethod method) {
        return new HttpPatchMethodPredicate(uri, protocol, method);
    }

    public static Predicate<HttpServerRequest> patch(String uri) {
        return HttpPatchMethodPredicate.http(uri, null, HttpMethod.PATCH);
    }

    HttpPatchMethodPredicate(String uri, @Nullable HttpVersion protocol, HttpMethod method) {
        this.protocol = protocol;
        this.uri = Objects.requireNonNull(uri, "uri");
        this.method = Objects.requireNonNull(method, "method");
        this.template = new UriPathTemplate(uri);
    }

    @Override
    public Map<String, String> apply(Object key) {
        Map<String, String> headers = this.template.match(key.toString());
        if (!headers.isEmpty()) {
            return headers;
        }
        return null;
    }

    @Override
    public boolean test(HttpServerRequest key) {
        return (this.protocol == null || this.protocol.equals((Object)key.version())) && this.method.equals((Object)key.method()) && this.template.matches(key.uri());
    }

    static final class UriPathTemplate {
        private static final Pattern FULL_SPLAT_PATTERN = Pattern.compile("[\\*][\\*]");
        private static final String FULL_SPLAT_REPLACEMENT = ".*";
        private static final Pattern NAME_SPLAT_PATTERN = Pattern.compile("\\{([^/]+?)\\}[\\*][\\*]");
        private static final Pattern NAME_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
        private static final Pattern URL_PATTERN = Pattern.compile("(?:(\\w+)://)?((?:\\[.+?])|(?<!\\[)(?:[^/?]+?))(?::(\\d{2,5}))?([/?].*)?");
        private final List<String> pathVariables = new ArrayList<String>();
        private final Pattern uriPattern;

        private static String getNameSplatReplacement(String name) {
            return "(?<" + name + ">.*)";
        }

        private static String getNameReplacement(String name) {
            return "(?<" + name + ">[^\\/]*)";
        }

        static String filterQueryParams(String uri) {
            int hasQuery = uri.lastIndexOf(63);
            if (hasQuery != -1) {
                return uri.substring(0, hasQuery);
            }
            return uri;
        }

        static String filterHostAndPort(String uri) {
            if (uri.startsWith("/")) {
                return uri;
            }
            Matcher matcher = URL_PATTERN.matcher(uri);
            if (matcher.matches()) {
                String path = matcher.group(4);
                return path == null ? "/" : path;
            }
            throw new IllegalArgumentException("Unable to parse url [" + uri + "]");
        }

        UriPathTemplate(String uriPattern) {
            String name;
            int i;
            String s = "^" + UriPathTemplate.filterQueryParams(UriPathTemplate.filterHostAndPort(uriPattern));
            Matcher m = NAME_SPLAT_PATTERN.matcher(s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(UriPathTemplate.getNameSplatReplacement(name));
                    m.reset(s);
                }
            }
            m = NAME_PATTERN.matcher(s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(UriPathTemplate.getNameReplacement(name));
                    m.reset(s);
                }
            }
            m = FULL_SPLAT_PATTERN.matcher(s);
            while (m.find()) {
                s = m.replaceAll(FULL_SPLAT_REPLACEMENT);
                m.reset(s);
            }
            this.uriPattern = Pattern.compile(s + "$");
        }

        public boolean matches(String uri) {
            return this.matcher(uri).matches();
        }

        Map<String, String> match(String uri) {
            HashMap<String, String> pathParameters = new HashMap<String, String>(this.pathVariables.size());
            Matcher m = this.matcher(uri);
            if (m.matches()) {
                int i = 1;
                for (String name : this.pathVariables) {
                    String val = m.group(i++);
                    pathParameters.put(name, val);
                }
            }
            return pathParameters;
        }

        private Matcher matcher(String uri) {
            uri = UriPathTemplate.filterQueryParams(UriPathTemplate.filterHostAndPort(uri));
            return this.uriPattern.matcher(uri);
        }
    }
}

