/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.changelog;

import com.github.cloudyrock.mongock.ChangeLog;
import io.mongock.api.annotations.ChangeUnit;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.Validable;
import io.mongock.runner.core.annotation.AnnotationProcessor;
import io.mongock.runner.core.annotation.LegacyAnnotationProcessor;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.runner.core.internal.ChangeSetItem;
import io.mongock.utils.CollectionUtils;
import io.mongock.utils.StringUtils;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.reflections.Reflections;

public abstract class ChangeLogServiceBase<CHANGELOG extends ChangeLogItem<CHANGESET>, CHANGESET extends ChangeSetItem>
implements Validable {
    private final LegacyAnnotationProcessor<CHANGESET> legacyAnnotationProcessor;
    private final AnnotationProcessor annotationProcessor;
    protected Function<AnnotatedElement, Boolean> profileFilter;
    private Function<Class<?>, Object> changeLogInstantiator;
    private List<String> changeLogsBasePackageList = Collections.emptyList();
    private List<Class<?>> changeLogsBaseClassList = Collections.emptyList();
    private ArtifactVersion startSystemVersion = new DefaultArtifactVersion("0");
    private ArtifactVersion endSystemVersion = new DefaultArtifactVersion(String.valueOf(Integer.MAX_VALUE));

    public ChangeLogServiceBase(AnnotationProcessor annotationProcessor, LegacyAnnotationProcessor<CHANGESET> legacyAnnotationProcessor) {
        this.legacyAnnotationProcessor = legacyAnnotationProcessor;
        this.annotationProcessor = annotationProcessor;
    }

    protected LegacyAnnotationProcessor<CHANGESET> getLegacyAnnotationProcessor() {
        return this.legacyAnnotationProcessor;
    }

    protected AnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    protected List<String> getChangeLogsBasePackageList() {
        return this.changeLogsBasePackageList;
    }

    public void setChangeLogsBasePackageList(List<String> changeLogsBasePackageList) {
        this.changeLogsBasePackageList = changeLogsBasePackageList;
    }

    protected List<Class<?>> getChangeLogsBaseClassList() {
        return this.changeLogsBaseClassList;
    }

    public void setChangeLogsBaseClassList(List<Class<?>> changeLogsBaseClassList) {
        this.changeLogsBaseClassList = changeLogsBaseClassList;
    }

    protected ArtifactVersion getStartSystemVersion() {
        return this.startSystemVersion;
    }

    public void setStartSystemVersion(String startSystemVersion) {
        this.startSystemVersion = new DefaultArtifactVersion(startSystemVersion);
    }

    protected ArtifactVersion getEndSystemVersion() {
        return this.endSystemVersion;
    }

    public void setEndSystemVersion(String endSystemVersion) {
        this.endSystemVersion = new DefaultArtifactVersion(endSystemVersion);
    }

    protected Function<AnnotatedElement, Boolean> getProfileFilter() {
        return this.profileFilter;
    }

    public void setProfileFilter(Function<AnnotatedElement, Boolean> profileFilter) {
        this.profileFilter = profileFilter;
    }

    protected Optional<Function<Class<?>, Object>> getChangeLogInstantiator() {
        return Optional.ofNullable(this.changeLogInstantiator);
    }

    public void runValidation() throws MongockException {
        if ((CollectionUtils.isNullEmpty(this.changeLogsBasePackageList) || !this.changeLogsBasePackageList.stream().allMatch(StringUtils::hasText)) && CollectionUtils.isNullEmpty(this.changeLogsBaseClassList)) {
            throw new MongockException("Scan package for changeLogs is not set: use appropriate setter");
        }
    }

    public SortedSet<CHANGELOG> fetchChangeLogs() {
        TreeSet changeLogs = this.mergeChangeLogClassesAndPackages().stream().filter(changeLogClass -> this.profileFilter != null ? this.profileFilter.apply((AnnotatedElement)changeLogClass) : true).map(this::buildChangeLogObject).collect(Collectors.toCollection(() -> new TreeSet(new ChangeLogComparator())));
        this.validateDuplications(changeLogs);
        return changeLogs;
    }

    private void validateDuplications(Set<CHANGELOG> changeLogs) {
        ThrowableHashSet allChangeSets = new ThrowableHashSet();
        changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).forEach(allChangeSets::addAndThrow);
    }

    private Set<Class<?>> mergeChangeLogClassesAndPackages() {
        Stream scannedPackageStream = this.changeLogsBasePackageList != null && !this.changeLogsBasePackageList.isEmpty() ? Stream.concat(new Reflections(new Object[]{this.changeLogsBasePackageList}).getTypesAnnotatedWith(ChangeLog.class).stream(), new Reflections(new Object[]{this.changeLogsBasePackageList}).getTypesAnnotatedWith(ChangeUnit.class).stream()) : Stream.empty();
        return Stream.concat(this.changeLogsBaseClassList.stream(), scannedPackageStream).collect(Collectors.toSet());
    }

    protected List<CHANGESET> fetchChangeSetMethodsSorted(Class<?> type) throws MongockException {
        List<CHANGESET> changeSets = this.getChangeSetWithCompanionMethods(Arrays.asList(type.getDeclaredMethods()));
        changeSets.sort(new ChangeSetComparator());
        return changeSets;
    }

    private List<CHANGESET> getChangeSetWithCompanionMethods(List<Method> allMethods) throws MongockException {
        ArrayList result = new ArrayList();
        HashSet changeSetIdsAlreadyProcessed = new HashSet();
        allMethods.stream().filter(this.legacyAnnotationProcessor::isMethodAnnotatedAsChange).collect(Collectors.toList()).forEach(changeSetMethod -> {
            String changeSetId = this.legacyAnnotationProcessor.getId((Method)changeSetMethod);
            CHANGESET changeSetItem = this.legacyAnnotationProcessor.getChangePerformerItem((Method)changeSetMethod, null);
            this.checkChangeSetDuplication(changeSetIdsAlreadyProcessed, changeSetId);
            changeSetIdsAlreadyProcessed.add(changeSetId);
            if (this.isChangeSetWithinSystemVersionRange(changeSetItem)) {
                result.add(changeSetItem);
            }
        });
        return result;
    }

    private boolean isChangeSetWithinSystemVersionRange(CHANGESET changeSetAnn) {
        boolean isWithinVersion = false;
        String versionString = ((ChangeSetItem)changeSetAnn).getSystemVersion();
        DefaultArtifactVersion version = new DefaultArtifactVersion(versionString);
        if (version.compareTo((Object)this.startSystemVersion) >= 0 && version.compareTo((Object)this.endSystemVersion) <= 0) {
            isWithinVersion = true;
        }
        return isWithinVersion;
    }

    private CHANGELOG buildChangeLogObject(Class<?> changeLogClass) {
        try {
            return this.isLegacyAnnotation(changeLogClass) ? this.buildChangeLogInstanceFromLegacy(changeLogClass) : this.buildChangeLogInstance(changeLogClass);
        }
        catch (MongockException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MongockException((Throwable)ex);
        }
    }

    private boolean isLegacyAnnotation(Class<?> changeLogClass) {
        return !changeLogClass.isAnnotationPresent(ChangeUnit.class);
    }

    protected abstract CHANGELOG buildChangeLogInstance(Class<?> var1) throws MongockException;

    protected abstract CHANGELOG buildChangeLogInstanceFromLegacy(Class<?> var1) throws MongockException;

    private void checkChangeSetDuplication(Set<String> changeSetIdsAlreadyProcessed, String changeSetId) {
        if (changeSetIdsAlreadyProcessed.contains(changeSetId)) {
            throw new MongockException(String.format("Duplicated changeset id found: '%s'", changeSetId));
        }
    }

    private void checkRollbackMatchesChangeSet(Set<String> changeSetIds, Method method, String rollbackId) {
        if (!changeSetIds.contains(rollbackId)) {
            throw new MongockException(String.format("Rollback method[%s] in class[%s] with id[%s] doesn't match any changeSet", method.getName(), method.getDeclaringClass().getSimpleName(), rollbackId));
        }
    }

    private void checkRollbackDuplication(Set<String> rollbacksAlreadyProcessed, String rollbackId) {
        if (rollbacksAlreadyProcessed.contains(rollbackId)) {
            throw new MongockException(String.format("Multiple rollbacks matching the same changeSetId[%s]. Only one rollback allowed per changeSet", rollbackId));
        }
    }

    protected List<CHANGESET> fetchListOfChangeSetsFromClass(Class<?> type) {
        return this.getAllChanges(type).filter(changeSetItem -> this.getLegacyAnnotationProcessor().isChangeSet(changeSetItem.getMethod())).collect(Collectors.toList());
    }

    private Stream<CHANGESET> getAllChanges(Class<?> type) {
        return this.fetchChangeSetMethodsSorted(type).stream().filter(changeSet -> this.profileFilter != null ? this.profileFilter.apply(changeSet.getMethod()) : true);
    }

    private class ThrowableHashSet
    extends HashSet<ChangeSetItem> {
        private ThrowableHashSet() {
        }

        public void addAndThrow(ChangeSetItem e) {
            if (!this.add(e)) {
                throw new MongockException("Change with id[%s] duplicated", new Object[]{e.getId()});
            }
        }
    }

    private class ChangeLogComparator
    implements Comparator<CHANGELOG>,
    Serializable {
        private static final long serialVersionUID = -358162121872177974L;

        private ChangeLogComparator() {
        }

        @Override
        public int compare(CHANGELOG changeLog1, CHANGELOG changeLog2) {
            String val1 = ((ChangeLogItem)changeLog1).getOrder();
            String val2 = ((ChangeLogItem)changeLog2).getOrder();
            if (StringUtils.hasText((String)val1) && StringUtils.hasText((String)val2) && !val1.equals(val2)) {
                return val1.compareTo(val2);
            }
            if (StringUtils.hasText((String)val1) && !StringUtils.hasText((String)val2)) {
                return -1;
            }
            if (StringUtils.hasText((String)val2) && !StringUtils.hasText((String)val1)) {
                return 1;
            }
            return ((ChangeLogItem)changeLog1).getType().getCanonicalName().compareTo(((ChangeLogItem)changeLog2).getType().getCanonicalName());
        }
    }

    private class ChangeSetComparator
    implements Comparator<CHANGESET>,
    Serializable {
        private static final long serialVersionUID = -854690868262484102L;

        private ChangeSetComparator() {
        }

        @Override
        public int compare(CHANGESET c1, CHANGESET c2) {
            return ((ChangeSetItem)c1).getOrder().compareTo(((ChangeSetItem)c2).getOrder());
        }
    }
}

