/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.operation.change;

import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.config.executor.ChangeExecutorConfiguration;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.api.entry.ExecutedChangeEntry;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.runner.core.executor.Executor;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.runner.core.internal.ChangeSetItem;
import io.mongock.utils.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class MigrationExecutorBase<CONFIG extends ChangeExecutorConfiguration>
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(MigrationExecutorBase.class);
    protected final Boolean globalTransactionEnabled;
    protected final Deque<Pair<Object, ChangeSetItem>> changeSetsToRollBack = new ArrayDeque<Pair<Object, ChangeSetItem>>();
    protected final ConnectionDriver<ChangeEntry> driver;
    protected final String serviceIdentifier;
    protected final boolean trackIgnored;
    protected final Set<ChangeLogItem<ChangeSetItem>> changeLogs;
    protected final Map<String, Object> metadata;
    private final ChangeLogRuntime changeLogRuntime;
    private final String defaultAuthor;
    protected boolean executionInProgress = false;
    protected final String executionId;
    private final TransactionStrategy transactionStrategy;
    protected List<ExecutedChangeEntry> executedChangeEntries = null;

    public MigrationExecutorBase(String executionId, Set<ChangeLogItem<ChangeSetItem>> changeLogs, ConnectionDriver<ChangeEntry> driver, ChangeLogRuntime changeLogRuntime, CONFIG config) {
        this.executionId = executionId;
        this.driver = driver;
        this.changeLogRuntime = changeLogRuntime;
        this.metadata = config.getMetadata();
        this.serviceIdentifier = config.getServiceIdentifier();
        this.trackIgnored = config.isTrackIgnored();
        this.changeLogs = changeLogs;
        this.globalTransactionEnabled = config.getTransactionEnabled().orElse(null);
        this.transactionStrategy = config.getTransactionStrategy();
        this.defaultAuthor = config.getDefaultMigrationAuthor();
    }

    @Override
    public boolean isExecutionInProgress() {
        return this.executionInProgress;
    }

    /*
     * Loose catch block
     */
    @Override
    public Boolean executeMigration() {
        this.initializationAndValidation();
        try {
            Boolean bl;
            try (LockManager lockManager = this.driver.getLockManager();){
                this.loadExecutedChangeEntries();
                if (!this.isThereAnyChangeSetItemToBeExecuted(this.changeLogs)) {
                    logger.info("Mongock skipping the data migration. All change set items are already executed or there is no change set item.");
                    Boolean bl2 = false;
                    return bl2;
                }
                lockManager.acquireLockDefault();
                this.loadExecutedChangeEntries();
                String executionHostname = this.generateExecutionHostname(this.executionId);
                logger.info("Mongock starting the data migration sequence id[{}]...", (Object)this.executionId);
                this.processMigration(this.changeLogs, this.executionId, executionHostname);
                bl = true;
            }
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.executionInProgress = false;
            logger.info("Mongock has finished");
        }
    }

    protected void processMigration(Collection<ChangeLogItem<ChangeSetItem>> changeLogs, String executionId, String executionHostname) {
        this.prepareForStageExecutionIfApply(this.isStrategyPerMigration());
        this.driver.getTransactioner().filter(t -> this.isStrategyPerMigration() && this.isTransactional()).orElse(Runnable::run).executeInTransaction(() -> this.processChangeLogs(executionId, executionHostname, changeLogs));
    }

    protected void processChangeLogs(String executionId, String executionHostname, Collection<ChangeLogItem<ChangeSetItem>> changeLogs) {
        for (ChangeLogItem<ChangeSetItem> changeLog : changeLogs) {
            this.processSingleChangeLog(executionId, executionHostname, changeLog);
        }
    }

    protected void processSingleChangeLog(String executionId, String executionHostname, ChangeLogItem<ChangeSetItem> changeLog) {
        block2: {
            try {
                this.prepareForStageExecutionIfApply(this.isStrategyPerChangeLog());
                Object changeLogInstance = this.getChangeLogInstance(changeLog.getType());
                this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLog.getBeforeItems());
                this.processChangeLogInTransactionIfApplies(executionId, executionHostname, changeLogInstance, changeLog);
            }
            catch (Exception e) {
                if (!changeLog.isFailFast()) break block2;
                this.rollbackProcessedChangeSetsIfApply(executionId, executionHostname, this.changeSetsToRollBack);
                throw e;
            }
        }
    }

    protected Object getChangeLogInstance(Class<?> changeLogClass) {
        this.injectDependenciesFromDriver();
        return this.changeLogRuntime.getInstance(changeLogClass);
    }

    protected void processChangeLogInTransactionIfApplies(String executionId, String executionHostname, Object changeLogInstance, ChangeLogItem<ChangeSetItem> changeLogItem) {
        this.driver.getTransactioner().filter(c -> this.isStrategyPerChangeLog() && this.isTransactional()).orElse(Runnable::run).executeInTransaction(() -> this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLogItem.getChangeSetItems()));
    }

    protected void loopRawChangeSets(String executionId, String executionHostName, Object changeLogInstance, List<? extends ChangeSetItem> changeSets) {
        for (ChangeSetItem changeSetItem : changeSets) {
            this.saveChangeSetToRollbackIfApply(changeLogInstance, changeSetItem);
            this.processSingleChangeSet(executionId, executionHostName, changeLogInstance, changeSetItem);
        }
    }

    private void saveChangeSetToRollbackIfApply(Object changeLogInstance, ChangeSetItem changeSet) {
        if (this.shouldChangeSetBeStoredToRollback(changeSet)) {
            this.changeSetsToRollBack.push((Pair<Object, ChangeSetItem>)new Pair(changeLogInstance, (Object)changeSet));
        }
    }

    private boolean shouldChangeSetBeStoredToRollback(ChangeSetItem changeSet) {
        return !this.isTransactional() || this.isStrategyPerChangeLog() && changeSet.isBeforeChangeSets();
    }

    protected void rollbackProcessedChangeSetsIfApply(String executionId, String hostname, Deque<Pair<Object, ChangeSetItem>> processedChangeSets) {
        logger.info("Mongock migration aborted and DB transaction not enabled. Starting manual rollback process");
        processedChangeSets.forEach(pair -> {
            try {
                this.rollbackIfPresentAndTrackChangeEntry(executionId, hostname, pair.getFirst(), (ChangeSetItem)pair.getSecond());
            }
            catch (Exception e) {
                throw e instanceof MongockException ? (MongockException)e : new MongockException((Throwable)e);
            }
        });
    }

    protected void processSingleChangeSet(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSet) {
        try {
            this.executeAndLogChangeSet(executionId, executionHostname, changeLogInstance, changeSet);
        }
        catch (Exception e) {
            this.processExceptionOnChangeSetExecution(e, changeSet.getMethod(), changeSet.isFailFast());
        }
    }

    protected String generateExecutionHostname(String executionId) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostname = "unknown-host." + executionId;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.serviceIdentifier)) {
            hostname = hostname + "-";
            hostname = hostname + this.serviceIdentifier;
        }
        return hostname;
    }

    protected boolean isThereAnyChangeSetItemToBeExecuted(Collection<ChangeLogItem<ChangeSetItem>> changeLogs) {
        return changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).anyMatch(changeSetItem -> changeSetItem.isRunAlways() || !this.isAlreadyExecuted((ChangeSetItem)changeSetItem));
    }

    protected boolean isAlreadyExecuted(ChangeSetItem changeSetItem) {
        return this.executedChangeEntries.stream().anyMatch(changeEntry -> changeEntry.getChangeId().equals(changeSetItem.getId()) && changeEntry.getAuthor().equals(changeSetItem.getAuthor()));
    }

    protected void executeAndLogChangeSet(String executionId, String executionHostname, Object changelogInstance, ChangeSetItem changeSetItem) throws IllegalAccessException, InvocationTargetException {
        ChangeEntry changeEntry = null;
        boolean alreadyExecuted = false;
        ChangeType type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
        try {
            alreadyExecuted = this.isAlreadyExecuted(changeSetItem);
            if (!alreadyExecuted || changeSetItem.isRunAlways()) {
                logger.debug("executing changeSet[{}]", (Object)changeSetItem.getId());
                long executionTimeMillis = this.executeChangeSetMethod(changeSetItem.getMethod(), changelogInstance);
                changeEntry = this.createChangeEntryInstance(executionId, executionHostname, changeSetItem, executionTimeMillis, ChangeState.EXECUTED, type);
                logger.debug("successfully executed changeSet[{}]", (Object)changeSetItem.getId());
            } else {
                changeEntry = this.createChangeEntryInstance(executionId, executionHostname, changeSetItem, -1L, ChangeState.IGNORED, type);
            }
            if (changeEntry != null) {
                this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
                this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
            }
        }
        catch (Exception ex) {
            try {
                logger.debug("failure when executing changeSet[{}]", (Object)changeSetItem.getId());
                changeEntry = this.createChangeEntryInstance(executionId, executionHostname, changeSetItem, -1L, ChangeState.FAILED, type);
                throw ex;
            }
            catch (Throwable throwable) {
                if (changeEntry != null) {
                    this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
                    this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
                }
                throw throwable;
            }
        }
    }

    private void trackChangeEntry(ChangeSetItem changeSetItem, ChangeEntry changeEntry, boolean alreadyExecuted) {
        if (!(changeSetItem.isRunAlways() && alreadyExecuted || changeEntry.getState() == ChangeState.IGNORED && !this.trackIgnored)) {
            this.driver.getChangeEntryService().saveOrUpdate(changeEntry);
        }
    }

    protected void rollbackIfPresentAndTrackChangeEntry(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSetItem) throws InvocationTargetException, IllegalAccessException {
        block5: {
            block4: {
                ChangeType type;
                if (!changeSetItem.getRollbackMethod().isPresent()) break block4;
                logger.debug("rolling back changeSet[{}]", (Object)changeSetItem.getId());
                ChangeState rollbackExecutionState = ChangeState.ROLLED_BACK;
                try {
                    this.executeChangeSetMethod(changeSetItem.getRollbackMethod().get(), changeLogInstance);
                    logger.debug("successfully rolled back changeSet[{}]", (Object)changeSetItem.getId());
                    type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                }
                catch (Exception rollbackException) {
                    try {
                        logger.debug("failure when rolling back changeSet[{}]:\n{}", (Object)changeSetItem.getId(), (Object)rollbackException.getMessage());
                        rollbackExecutionState = ChangeState.ROLLBACK_FAILED;
                        throw rollbackException;
                    }
                    catch (Throwable throwable) {
                        ChangeType type2 = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                        ChangeEntry changeEntry = this.createChangeEntryInstance(executionId, executionHostname, changeSetItem, -1L, rollbackExecutionState, type2);
                        this.logChangeEntry(changeEntry, changeSetItem, false);
                        this.trackChangeEntry(changeSetItem, changeEntry, false);
                        throw throwable;
                    }
                }
                ChangeEntry changeEntry = this.createChangeEntryInstance(executionId, executionHostname, changeSetItem, -1L, rollbackExecutionState, type);
                this.logChangeEntry(changeEntry, changeSetItem, false);
                this.trackChangeEntry(changeSetItem, changeEntry, false);
                break block5;
            }
            logger.warn("ChangeSet[{}] does not provide rollback method", (Object)changeSetItem.getId());
        }
    }

    private void logChangeEntry(ChangeEntry changeEntry, ChangeSetItem changeSetItem, boolean alreadyExecuted) {
        switch (changeEntry.getState()) {
            case EXECUTED: {
                logger.info("{}APPLIED - {}", (Object)(alreadyExecuted ? "RE-" : ""), (Object)changeEntry.toPrettyString());
                break;
            }
            case IGNORED: {
                logger.info("PASSED OVER - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case FAILED: {
                logger.info("FAILED OVER - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLED_BACK: {
                logger.info("ROLLED BACK - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLBACK_FAILED: {
                logger.info("ROLL BACK FAILED- {}", (Object)changeSetItem.toPrettyString());
            }
        }
    }

    protected ChangeEntry createChangeEntryInstance(String executionId, String executionHostname, ChangeSetItem changeSetItem, long executionTimeMillis, ChangeState state, ChangeType type) {
        return ChangeEntry.createInstance((String)executionId, (String)(StringUtils.isNotEmpty((CharSequence)changeSetItem.getAuthor()) ? changeSetItem.getAuthor() : this.defaultAuthor), (ChangeState)state, (ChangeType)type, (String)changeSetItem.getId(), (String)changeSetItem.getMethod().getDeclaringClass().getName(), (String)changeSetItem.getMethod().getName(), (long)executionTimeMillis, (String)executionHostname, this.metadata);
    }

    protected long executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance) throws IllegalAccessException, InvocationTargetException {
        long startingTime = System.currentTimeMillis();
        this.changeLogRuntime.runChangeSet(changeLogInstance, changeSetMethod);
        return System.currentTimeMillis() - startingTime;
    }

    protected void processExceptionOnChangeSetExecution(Exception exception, Method method, boolean throwException) {
        String exceptionMsg = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException().getMessage() : exception.getMessage();
        String finalMessage = String.format("Error in method[%s.%s] : %s", method.getDeclaringClass().getSimpleName(), method.getName(), exceptionMsg);
        if (throwException) {
            throw new MongockException(finalMessage, exception);
        }
        logger.warn(finalMessage, (Throwable)exception);
    }

    protected void initializationAndValidation() throws MongockException {
        this.executionInProgress = true;
        this.driver.initialize();
        this.driver.runValidation();
        this.changeLogRuntime.initialize(this.driver.getLockManager());
    }

    private void injectDependenciesFromDriver() {
        this.changeLogRuntime.updateDriverDependencies(this.driver.getDependencies());
    }

    protected void loadExecutedChangeEntries() {
        this.executedChangeEntries = this.driver.getChangeEntryService().getExecuted();
    }

    protected final boolean isTransactional() {
        return this.globalTransactionEnabled == null ? this.driver.isTransactionable() : this.globalTransactionEnabled != false && this.driver.isTransactionable();
    }

    protected final boolean isStrategyPerChangeLog() {
        return this.transactionStrategy == null || this.transactionStrategy == TransactionStrategy.CHANGE_UNIT;
    }

    protected final boolean isStrategyPerMigration() {
        return this.transactionStrategy == TransactionStrategy.EXECUTION;
    }

    protected void prepareForStageExecutionIfApply(boolean applyPreparation) {
        if (applyPreparation) {
            this.driver.prepareForExecutionBlock();
            this.changeSetsToRollBack.clear();
        }
    }
}

