/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.internal;

import io.mongock.api.exception.MongockException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

public class ChangeSetItem {
    private final String id;
    private final String author;
    private final String order;
    private final boolean runAlways;
    private final String systemVersion;
    private final Method method;
    private final boolean failFast;
    private final Method rollbackMethod;
    private final boolean beforeChangeSets;

    public ChangeSetItem(String id, String author, String order, boolean runAlways, String systemVersion, boolean failFast, Method changeSetMethod, Method rollbackMethod, boolean beforeChangeSets) {
        if (id == null || id.trim().isEmpty()) {
            throw new MongockException("id cannot be null or empty.");
        }
        if (author == null || author.trim().isEmpty()) {
            throw new MongockException("author cannot be null or empty.");
        }
        this.id = id;
        this.author = author;
        this.order = order;
        this.runAlways = runAlways;
        this.systemVersion = systemVersion;
        this.method = changeSetMethod;
        this.failFast = failFast;
        this.rollbackMethod = rollbackMethod;
        this.beforeChangeSets = beforeChangeSets;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public Optional<Method> getRollbackMethod() {
        return Optional.ofNullable(this.rollbackMethod);
    }

    public boolean isBeforeChangeSets() {
        return this.beforeChangeSets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSetItem that = (ChangeSetItem)o;
        return this.id.equals(that.id) && Objects.equals(this.author, that.author);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.author);
    }

    public String toString() {
        return "ChangeSetItem{id='" + this.id + '\'' + ", author='" + this.author + '\'' + ", order='" + this.order + '\'' + ", runAlways=" + this.runAlways + ", systemVersion='" + this.systemVersion + '\'' + ", method=" + this.method + ", failFast=" + this.failFast + ", beforeChangeSets=" + this.beforeChangeSets + '}';
    }

    public String toPrettyString() {
        return "ChangeEntry{\"id\"=\"" + this.id + "\", \"author\"=\"" + this.author + "\", \"class\"=\"" + this.method.getDeclaringClass().getSimpleName() + "\", \"method\"=\"" + this.method.getName() + "\"" + '}';
    }
}

