/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.api.entry;

import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.utils.StringUtils;
import io.mongock.utils.field.Field;
import java.util.Date;

public class ChangeEntry {
    @Field(value="executionId")
    private final String executionId;
    @Field(value="changeId")
    private final String changeId;
    @Field(value="author")
    private final String author;
    @Field(value="timestamp")
    private final Date timestamp;
    @Field(value="state")
    private final ChangeState state;
    @Field(value="type")
    private final ChangeType type;
    @Field(value="changeLogClass")
    private final String changeLogClass;
    @Field(value="changeSetMethod")
    private final String changeSetMethod;
    @Field(value="metadata")
    private final Object metadata;
    @Field(value="executionMillis")
    private final long executionMillis;
    @Field(value="executionHostname")
    private final String executionHostname;

    public ChangeEntry(String executionId, String changeId, String author, Date timestamp, ChangeState state, ChangeType type, String changeLogClass, String changeSetMethod, long executionMillis, String executionHostname, Object metadata) {
        this.executionId = executionId;
        this.changeId = changeId;
        this.author = author;
        this.timestamp = new Date(timestamp.getTime());
        this.state = state;
        this.type = type;
        this.changeLogClass = changeLogClass;
        this.changeSetMethod = changeSetMethod;
        this.executionMillis = executionMillis;
        this.executionHostname = executionHostname;
        this.metadata = metadata;
    }

    public static ChangeEntry createInstance(String executionId, String author, ChangeState state, ChangeType type, String changeSetId, String changeSetClassName, String changeSetName, long executionMillis, String executionHostname, Object metadata) {
        return new ChangeEntry(executionId, changeSetId, author, new Date(), state, type, changeSetClassName, changeSetName, executionMillis, executionHostname, metadata);
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ChangeState getState() {
        return this.state;
    }

    public String getChangeLogClass() {
        return this.changeLogClass;
    }

    public String getChangeSetMethod() {
        return this.changeSetMethod;
    }

    public long getExecutionMillis() {
        return this.executionMillis;
    }

    public String getExecutionHostname() {
        return this.executionHostname;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public ChangeType getType() {
        return this.type;
    }

    public String toString() {
        String sb = "ChangeEntry{executionId='" + this.executionId + '\'' + ", changeId='" + this.changeId + '\'' + ", author='" + this.author + '\'' + ", timestamp=" + this.timestamp + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", changeLogClass='" + this.changeLogClass + '\'' + ", changeSetMethod='" + this.changeSetMethod + '\'' + ", metadata=" + this.metadata + ", executionMillis=" + this.executionMillis + ", executionHostname='" + this.executionHostname + '\'' + '}';
        return sb;
    }

    public String toPrettyString() {
        return "ChangeEntry{\"id\"=\"" + this.changeId + "\", \"author\"=\"" + this.author + "\", \"class\"=\"" + StringUtils.getSimpleClassName((String)this.changeLogClass) + "\", \"method\"=\"" + this.changeSetMethod + "\"" + '}';
    }
}

