/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper;

import io.mongock.cli.util.banner.Banner;
import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import io.mongock.cli.wrapper.CliJarLauncher;
import io.mongock.cli.wrapper.LauncherFactory;
import io.mongock.cli.wrapper.util.ArgsUtil;
import java.io.File;
import java.util.stream.Stream;
import org.springframework.boot.loader.archive.JarFileArchive;

public class MongockCli {
    private static final CliLogger logger = CliLoggerFactory.getLogger(MongockCli.class);
    private static final String APP_JAR_ARG_SHORT = "-aj";
    private static final String APP_JAR_ARG_LONG = "--app-jar";
    private static final String CLI_SPRING_JAR_ARG = "--cli-spring-jar";
    private static final String CLI_CORE_JAR_ARG = "-cli-core-jar";
    private static final String LOG_LEVEL_ARG = "--log-level";
    private static final String[] argumentsToCleanUp = new String[]{"--app-jar", "-aj", "--cli-spring-jar", "-cli-core-jar", "--log-level"};

    public static void main(String ... args) throws Exception {
        MongockCli.setLogger(args);
        MongockCli.printArgs(args);
        String appJar = ArgsUtil.getOptionalParam(args, APP_JAR_ARG_LONG).orElseGet(() -> ArgsUtil.getParameter(args, APP_JAR_ARG_SHORT));
        CliJarLauncher launcher = LauncherFactory.getLauncher(new JarFileArchive(new File(appJar)));
        launcher.appJar(appJar).cliJar(ArgsUtil.getParameter(args, launcher.getType() == CliJarLauncher.Type.SPRINGBOOT ? CLI_SPRING_JAR_ARG : CLI_CORE_JAR_ARG)).loadClasses().launch(ArgsUtil.getCleanArgs(args, argumentsToCleanUp));
    }

    private static void printArgs(String[] args) {
        StringBuilder sb = new StringBuilder("CLI arguments: ");
        Stream.of(args).forEach(arg -> sb.append((String)arg).append(" "));
        logger.debug(sb.toString(), new Object[0]);
    }

    private static void setLogger(String[] args) {
        CliLoggerFactory.setLevel(ArgsUtil.getOptionalParam(args, LOG_LEVEL_ARG).map(CliLogger.Level::fromStringDefaultInfo).orElse(CliLogger.Level.INFO));
    }

    static {
        Banner.print(System.out);
    }
}

