/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.api.config;

import io.mongock.api.config.LegacyMigration;
import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.config.executor.ExecutorConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongockConfiguration
implements ExecutorConfiguration {
    public static final String DEFAULT_MIGRATION_AUTHOR = "default_author";
    public static final long DEFAULT_QUIT_TRYING_AFTER_MILLIS = 180000L;
    private static final Logger logger = LoggerFactory.getLogger(MongockConfiguration.class);
    private static final String LEGACY_DEFAULT_MIGRATION_REPOSITORY_NAME = "mongockChangeLog";
    private static final String LEGACY_DEFAULT_LOCK_REPOSITORY_NAME = "mongockLock";
    private static final String DEPRECATED_PROPERTY_TEMPLATE = "\n********************************************************************************\nPROPERTY [{}] DEPRECATED. IT WILL BE REMOVED IN NEXT VERSIONS\nPlease use the following properties instead: [{}]\n********************************************************************************";
    private String migrationRepositoryName;
    private boolean indexCreation = true;
    private String lockRepositoryName;
    private long lockAcquiredForMillis = 60000L;
    private Long lockQuitTryingAfterMillis;
    private long lockTryFrequencyMillis = 1000L;
    private boolean throwExceptionIfCannotObtainLock = true;
    private boolean trackIgnored = false;
    private boolean enabled = true;
    private List<String> migrationScanPackage = new ArrayList<String>();
    private String startSystemVersion = "0";
    private String endSystemVersion = String.valueOf(Integer.MAX_VALUE);
    private String serviceIdentifier = null;
    private Map<String, Object> metadata;
    private LegacyMigration legacyMigration = null;
    private Boolean transactionEnabled;
    private String defaultMigrationAuthor = "default_author";
    private TransactionStrategy transactionStrategy = TransactionStrategy.CHANGE_UNIT;
    @Deprecated
    private Integer maxTries;
    @Deprecated
    private Long maxWaitingForLockMillis;

    private static long minutesToMillis(int minutes) {
        return (long)(minutes * 60) * 1000L;
    }

    public void updateFrom(MongockConfiguration from) {
        this.migrationRepositoryName = from.getMigrationRepositoryName();
        this.indexCreation = from.isIndexCreation();
        this.lockRepositoryName = from.getLockRepositoryName();
        this.lockAcquiredForMillis = from.getLockAcquiredForMillis();
        this.lockQuitTryingAfterMillis = from.getLockQuitTryingAfterMillis();
        this.lockTryFrequencyMillis = from.getLockTryFrequencyMillis();
        this.throwExceptionIfCannotObtainLock = from.isThrowExceptionIfCannotObtainLock();
        this.trackIgnored = from.isTrackIgnored();
        this.enabled = from.isEnabled();
        this.migrationScanPackage = from.getChangeLogsScanPackage();
        this.startSystemVersion = from.getStartSystemVersion();
        this.endSystemVersion = from.getEndSystemVersion();
        this.serviceIdentifier = from.getServiceIdentifier();
        this.metadata = from.getMetadata();
        this.legacyMigration = from.getLegacyMigration();
        this.transactionEnabled = from.getTransactionEnabled().orElse(null);
        this.transactionStrategy = from.getTransactionStrategy();
        this.maxTries = from.getMaxTries();
        this.maxWaitingForLockMillis = from.getMaxWaitingForLockMillis();
    }

    public long getLockAcquiredForMillis() {
        return this.lockAcquiredForMillis;
    }

    public void setLockAcquiredForMillis(long lockAcquiredForMillis) {
        this.lockAcquiredForMillis = lockAcquiredForMillis;
    }

    public long getLockQuitTryingAfterMillis() {
        if (this.lockQuitTryingAfterMillis == null) {
            if (this.maxWaitingForLockMillis != null) {
                return this.maxWaitingForLockMillis * (long)(this.maxTries != null ? this.maxTries : 3);
            }
            return 180000L;
        }
        return this.lockQuitTryingAfterMillis;
    }

    public void setLockQuitTryingAfterMillis(long lockQuitTryingAfterMillis) {
        this.lockQuitTryingAfterMillis = lockQuitTryingAfterMillis;
    }

    public long getLockTryFrequencyMillis() {
        return this.lockTryFrequencyMillis;
    }

    public void setLockTryFrequencyMillis(long lockTryFrequencyMillis) {
        this.lockTryFrequencyMillis = lockTryFrequencyMillis;
    }

    public String getMigrationRepositoryName() {
        return this.migrationRepositoryName;
    }

    public void setMigrationRepositoryName(String migrationRepositoryName) {
        this.migrationRepositoryName = migrationRepositoryName;
    }

    public String getLockRepositoryName() {
        return this.lockRepositoryName;
    }

    public void setLockRepositoryName(String lockRepositoryName) {
        this.lockRepositoryName = lockRepositoryName;
    }

    public List<String> getMigrationScanPackage() {
        return this.migrationScanPackage;
    }

    public void setMigrationScanPackage(List<String> migrationScanPackage) {
        this.migrationScanPackage = migrationScanPackage;
    }

    public boolean isIndexCreation() {
        return this.indexCreation;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    @Override
    public boolean isTrackIgnored() {
        return this.trackIgnored;
    }

    public void setTrackIgnored(boolean trackIgnored) {
        this.trackIgnored = trackIgnored;
    }

    public boolean isThrowExceptionIfCannotObtainLock() {
        return this.throwExceptionIfCannotObtainLock;
    }

    public void setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getStartSystemVersion() {
        return this.startSystemVersion;
    }

    public void setStartSystemVersion(String startSystemVersion) {
        this.startSystemVersion = startSystemVersion;
    }

    public String getEndSystemVersion() {
        return this.endSystemVersion;
    }

    public void setEndSystemVersion(String endSystemVersion) {
        this.endSystemVersion = endSystemVersion;
    }

    @Override
    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public void setServiceIdentifier(String serviceIdentifier) {
        this.serviceIdentifier = serviceIdentifier;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Optional<Boolean> getTransactionEnabled() {
        return Optional.ofNullable(this.transactionEnabled);
    }

    public void setTransactionEnabled(boolean transactionEnabled) {
        this.transactionEnabled = transactionEnabled;
    }

    @Override
    public TransactionStrategy getTransactionStrategy() {
        return this.transactionStrategy;
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    @Override
    public String getDefaultMigrationAuthor() {
        return this.defaultMigrationAuthor;
    }

    public void setDefaultMigrationAuthor(String defaultMigrationAuthor) {
        this.defaultMigrationAuthor = defaultMigrationAuthor;
    }

    public LegacyMigration getLegacyMigration() {
        return this.legacyMigration;
    }

    public void setLegacyMigration(LegacyMigration legacyMigration) {
        this.legacyMigration = legacyMigration;
    }

    protected String getMigrationRepositoryNameDefault() {
        return LEGACY_DEFAULT_MIGRATION_REPOSITORY_NAME;
    }

    protected String getLockRepositoryNameDefault() {
        return LEGACY_DEFAULT_LOCK_REPOSITORY_NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MongockConfiguration)) {
            return false;
        }
        MongockConfiguration that = (MongockConfiguration)o;
        return this.indexCreation == that.indexCreation && this.lockAcquiredForMillis == that.lockAcquiredForMillis && this.lockTryFrequencyMillis == that.lockTryFrequencyMillis && this.throwExceptionIfCannotObtainLock == that.throwExceptionIfCannotObtainLock && this.trackIgnored == that.trackIgnored && this.enabled == that.enabled && Objects.equals(this.migrationRepositoryName, that.migrationRepositoryName) && Objects.equals(this.lockRepositoryName, that.lockRepositoryName) && Objects.equals(this.lockQuitTryingAfterMillis, that.lockQuitTryingAfterMillis) && Objects.equals(this.migrationScanPackage, that.migrationScanPackage) && Objects.equals(this.startSystemVersion, that.startSystemVersion) && Objects.equals(this.endSystemVersion, that.endSystemVersion) && Objects.equals(this.serviceIdentifier, that.serviceIdentifier) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.legacyMigration, that.legacyMigration) && Objects.equals(this.transactionEnabled, that.transactionEnabled) && Objects.equals(this.maxTries, that.maxTries) && Objects.equals(this.maxWaitingForLockMillis, that.maxWaitingForLockMillis);
    }

    public int hashCode() {
        return Objects.hash(this.migrationRepositoryName, this.indexCreation, this.lockRepositoryName, this.lockAcquiredForMillis, this.lockQuitTryingAfterMillis, this.lockTryFrequencyMillis, this.throwExceptionIfCannotObtainLock, this.trackIgnored, this.enabled, this.migrationScanPackage, this.startSystemVersion, this.endSystemVersion, this.serviceIdentifier, this.metadata, this.legacyMigration, this.transactionEnabled, this.maxTries, this.maxWaitingForLockMillis);
    }

    @Deprecated
    public String getChangeLogRepositoryName() {
        return this.migrationRepositoryName;
    }

    @Deprecated
    public void setChangeLogRepositoryName(String migrationRepositoryName) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"changeLogRepositoryName", (Object)"migrationRepositoryName");
        this.migrationRepositoryName = migrationRepositoryName;
    }

    @Deprecated
    public List<String> getChangeLogsScanPackage() {
        return this.migrationScanPackage;
    }

    @Deprecated
    public void setChangeLogsScanPackage(List<String> migrationScanPackage) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"changeLogsScanPackage", (Object)"migrationScanPackage");
        this.migrationScanPackage = migrationScanPackage;
    }

    @Deprecated
    public void setLockAcquiredForMinutes(int lockAcquiredForMinutes) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"lockAcquiredForMinutes", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.lockAcquiredForMillis = MongockConfiguration.minutesToMillis(lockAcquiredForMinutes);
    }

    @Deprecated
    public void setMaxWaitingForLockMinutes(int maxWaitingForLockMinutes) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"maxWaitingForLockMinutes", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.maxWaitingForLockMillis = MongockConfiguration.minutesToMillis(maxWaitingForLockMinutes);
    }

    @Deprecated
    protected Long getMaxWaitingForLockMillis() {
        return this.maxWaitingForLockMillis;
    }

    @Deprecated
    protected Integer getMaxTries() {
        return this.maxTries;
    }

    @Deprecated
    public void setMaxTries(int maxTries) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"maxTries", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.maxTries = maxTries;
    }
}

