/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor;

import io.changock.migration.api.annotations.NonLockGuarded;
import io.mongock.api.annotations.ChangeUnit;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.DependencyInjectionException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.driver.api.lock.guard.proxy.LockGuardProxyFactory;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.executor.dependency.DependencyManager;
import io.mongock.utils.LogUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogRuntimeImpl
implements ChangeLogRuntime {
    private static final Logger logger = LoggerFactory.getLogger(ChangeLogRuntimeImpl.class);
    private static final Function<Class<?>, Object> DEFAULT_FUNC_FOR_ANNOTATIONS = changeLogClass -> {
        try {
            return changeLogClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MongockException(e);
        }
    };
    private final Function<Class<?>, Object> instantiatorForAnnotations;
    private final DependencyManager dependencyManager;
    private final Function<Parameter, String> parameterNameProvider;
    private final Set<Class<?>> nonProxyableTypes;

    public ChangeLogRuntimeImpl(DependencyManager dependencyManager, Function<Parameter, String> parameterNameProvider, List<Class<?>> nonProxyableTypes) {
        this(DEFAULT_FUNC_FOR_ANNOTATIONS, dependencyManager, parameterNameProvider, nonProxyableTypes);
    }

    @Deprecated
    public ChangeLogRuntimeImpl(Function<Class<?>, Object> instantiatorForAnnotations, DependencyManager dependencyManager, Function<Parameter, String> parameterNameProvider, List<Class<?>> nonProxyableTypes) {
        this.instantiatorForAnnotations = instantiatorForAnnotations != null ? instantiatorForAnnotations : DEFAULT_FUNC_FOR_ANNOTATIONS;
        this.dependencyManager = dependencyManager;
        this.parameterNameProvider = parameterNameProvider;
        this.nonProxyableTypes = new HashSet(nonProxyableTypes);
    }

    @Override
    public void initialize(LockManager lockManager) {
        this.dependencyManager.setLockGuardProxyFactory(new LockGuardProxyFactory(lockManager));
    }

    @Override
    public void updateDriverDependencies(Set<ChangeSetDependency> dependencies) {
        this.dependencyManager.addDriverDependencies(dependencies);
        this.dependencyManager.runValidation();
    }

    @Override
    public void runChangeSet(Object changeLogInstance, Method changeSetMethod) throws IllegalAccessException, InvocationTargetException {
        List<Object> invokationParameters = this.getInvokationParameters(changeSetMethod);
        LogUtils.logMethodWithArguments(logger, changeSetMethod.getName(), invokationParameters);
        changeSetMethod.invoke(changeLogInstance, invokationParameters.toArray());
    }

    @Override
    public Object getInstance(Class<?> type) {
        if (!type.isAnnotationPresent(ChangeUnit.class)) {
            return this.instantiatorForAnnotations.apply(type);
        }
        Constructor<?> constructor = this.getConstructor(type);
        List<Object> invokationParameters = this.getInvokationParameters(constructor);
        LogUtils.logMethodWithArguments(logger, constructor.getName(), invokationParameters);
        try {
            return constructor.newInstance(invokationParameters.toArray());
        }
        catch (Exception e) {
            throw new MongockException(e);
        }
    }

    private List<Object> getInvokationParameters(Executable executable) {
        Class<?>[] parameterTypes = executable.getParameterTypes();
        Parameter[] parameters = executable.getParameters();
        ArrayList<Object> invokationParameters = new ArrayList<Object>(parameterTypes.length);
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            invokationParameters.add(this.getParameter(parameterTypes[paramIndex], parameters[paramIndex]));
        }
        return invokationParameters;
    }

    private Object getParameter(Class<?> parameterType, Parameter parameter) {
        String name = this.getParameterName(parameter);
        boolean makeItProxy = !parameterType.isAnnotationPresent(NonLockGuarded.class) && !parameter.isAnnotationPresent(NonLockGuarded.class) && !this.nonProxyableTypes.contains(parameterType);
        return this.dependencyManager.getDependency(parameterType, name, makeItProxy).orElseThrow(() -> new DependencyInjectionException(parameterType, name));
    }

    private String getParameterName(Parameter parameter) {
        return this.parameterNameProvider.apply(parameter);
    }

    private Constructor<?> getConstructor(Class<?> type) {
        return type.getConstructors()[0];
    }
}

