/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.metrics.buffering;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.metrics.StartupStep;

class BufferedStartupStep
implements StartupStep {
    private final String name;
    private final long id;
    private final Long parentId;
    private long startTime;
    private long endTime;
    private final DefaultTags tags;
    private final Consumer<BufferedStartupStep> recorder;

    BufferedStartupStep(long id, String name, Long parentId, Consumer<BufferedStartupStep> recorder) {
        this.id = id;
        this.parentId = parentId;
        this.tags = new DefaultTags();
        this.name = name;
        this.recorder = recorder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Long getParentId() {
        return this.parentId;
    }

    @Override
    public StartupStep.Tags getTags() {
        return this.tags;
    }

    @Override
    public StartupStep tag(String key, String value) {
        if (this.endTime != 0L) {
            throw new IllegalStateException("StartupStep has already ended.");
        }
        this.tags.add(key, value);
        return this;
    }

    @Override
    public StartupStep tag(String key, Supplier<String> value) {
        return this.tag(key, value.get());
    }

    @Override
    public void end() {
        this.recorder.accept(this);
    }

    long getStartTime() {
        return this.startTime;
    }

    void recordStartTime(long startTime) {
        this.startTime = startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    void recordEndTime(long endTime) {
        this.endTime = endTime;
    }

    static class DefaultTag
    implements StartupStep.Tag {
        private final String key;
        private final String value;

        DefaultTag(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static class DefaultTags
    implements StartupStep.Tags {
        private StartupStep.Tag[] tags = new StartupStep.Tag[0];

        DefaultTags() {
        }

        void add(String key, String value) {
            StartupStep.Tag[] newTags = new StartupStep.Tag[this.tags.length + 1];
            System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
            newTags[newTags.length - 1] = new DefaultTag(key, value);
            this.tags = newTags;
        }

        @Override
        public Iterator<StartupStep.Tag> iterator() {
            return new TagsIterator();
        }

        private class TagsIterator
        implements Iterator<StartupStep.Tag> {
            private int index = 0;

            private TagsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < DefaultTags.this.tags.length;
            }

            @Override
            public StartupStep.Tag next() {
                return DefaultTags.this.tags[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("tags are append only");
            }
        }
    }
}

