/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import liquibase.servicelocator.CustomResolverServiceLocator;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.liquibase.SpringPackageScanClassResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

public class LiquibaseServiceLocatorApplicationListener
implements ApplicationListener<ApplicationStartingEvent> {
    private static final Log logger = LogFactory.getLog(LiquibaseServiceLocatorApplicationListener.class);
    private static final boolean LIQUIBASE_PRESENT = ClassUtils.isPresent("liquibase.servicelocator.CustomResolverServiceLocator", LiquibaseServiceLocatorApplicationListener.class.getClassLoader());

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (LIQUIBASE_PRESENT) {
            new LiquibasePresent().replaceServiceLocator();
        }
    }

    private static class LiquibasePresent {
        private LiquibasePresent() {
        }

        void replaceServiceLocator() {
            CustomResolverServiceLocator customResolverServiceLocator = new CustomResolverServiceLocator((PackageScanClassResolver)new SpringPackageScanClassResolver(logger));
            ServiceLocator.setInstance((ServiceLocator)customResolverServiceLocator);
        }
    }
}

