/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper.standalone;

import io.mongock.api.annotations.MongockCliConfiguration;
import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import io.mongock.cli.wrapper.CliJarLauncher;
import io.mongock.cli.wrapper.util.ClassLoaderUtil;
import io.mongock.cli.wrapper.util.JarUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.springframework.boot.loader.archive.JarFileArchive;

public class StandaloneLauncher
implements CliJarLauncher {
    private static final CliLogger logger = CliLoggerFactory.getLogger(StandaloneLauncher.class);
    private final JarFileArchive appJarArchive;
    private String appJar;
    private String cliJar;
    private URLClassLoader classLoader;

    public StandaloneLauncher(JarFileArchive appArchive) {
        this.appJarArchive = appArchive;
    }

    @Override
    public CliJarLauncher.Type getType() {
        return CliJarLauncher.Type.STANDALONE;
    }

    @Override
    public CliJarLauncher cliJar(String cliJar) {
        this.cliJar = cliJar;
        return this;
    }

    @Override
    public CliJarLauncher appJar(String appJar) {
        this.appJar = appJar;
        return this;
    }

    @Override
    public CliJarLauncher loadClasses() {
        try {
            this.classLoader = this.buildClassLoader();
            ClassLoaderUtil.loadJarClasses(new JarFile(this.appJar), this.classLoader);
            ClassLoaderUtil.loadJarClasses(new JarFile(this.cliJar), this.classLoader);
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void launch(String[] args) {
        try {
            logger.info("launching Mongock CLI runner with Standalone launcher", new Object[0]);
            String mainClassName = JarUtil.getMainClass(this.appJarArchive);
            Class<?> mainClass = this.getMainClass(mainClassName);
            if (!mainClass.isAnnotationPresent(MongockCliConfiguration.class)) {
                throw new RuntimeException("Main class " + mainClassName + " not annotated with MongockCliConfiguration");
            }
            MongockCliConfiguration ann = mainClass.getAnnotation(MongockCliConfiguration.class);
            Class.forName("io.mongock.runner.core.builder.RunnerBuilderProvider", false, this.classLoader);
            Class<?> builderProviderImplClass = ann.sources()[0];
            Object runnerBuilder = this.getRunnerBuilder(builderProviderImplClass);
            Object cliBuilder = this.getCliBuilder();
            this.setRunnerBuilderToCli(runnerBuilder, cliBuilder);
            Object commandLine = this.buildCli(cliBuilder);
            this.executeCli(args, commandLine);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class<?> getMainClass(String mainClassName) throws ClassNotFoundException {
        logger.debug("Main class: " + mainClassName, new Object[0]);
        Class<?> mainClass = this.classLoader.loadClass(mainClassName);
        logger.debug("loaded Main class", new Object[0]);
        return mainClass;
    }

    private void executeCli(String[] args, Object commandLine) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        Stream.of(args).forEach(s -> sb.append((String)s).append(" "));
        logger.debug("executing CommandLine with args: " + sb, new Object[0]);
        Method executeMethod = commandLine.getClass().getDeclaredMethod("execute", String[].class);
        executeMethod.setAccessible(true);
        executeMethod.invoke(commandLine, new Object[]{args});
        logger.debug("successful call to commandLine.execute()", new Object[0]);
    }

    private Object buildCli(Object cliBuilder) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.debug("building CommandLine", new Object[0]);
        Method buildMethod = cliBuilder.getClass().getDeclaredMethod("build", new Class[0]);
        buildMethod.setAccessible(true);
        Object commandLine = buildMethod.invoke(cliBuilder, new Object[0]);
        logger.debug("successful built commandLine " + commandLine, new Object[0]);
        return commandLine;
    }

    private void setRunnerBuilderToCli(Object runnerBuilder, Object cliBuilder) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.debug("loading class RunnerBuilder", new Object[0]);
        Class<?> runnerBuilderClass = Class.forName("io.mongock.runner.core.builder.RunnerBuilder", false, this.classLoader);
        logger.debug("successfully loaded class RunnerBuilder", new Object[0]);
        logger.debug("setting RunnerBuilder to MongockCli.builder", new Object[0]);
        Method runnerBuilderSetter = cliBuilder.getClass().getDeclaredMethod("runnerBuilder", runnerBuilderClass);
        runnerBuilderSetter.setAccessible(true);
        runnerBuilderSetter.invoke(cliBuilder, runnerBuilder);
        logger.debug("successfully set RunnerBuilder to MongockCli.builder", new Object[0]);
    }

    private Object getCliBuilder() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.debug("loading MongockCLI class", new Object[0]);
        Class<?> mongockCliClass = Class.forName("io.mongock.cli.core.CliCoreRunner", false, this.classLoader);
        logger.debug("successfully loaded MongockCLI class", new Object[0]);
        logger.debug("obtaining builder setter", new Object[0]);
        Method builderMethod = mongockCliClass.getDeclaredMethod("builder", new Class[0]);
        builderMethod.setAccessible(true);
        Object cliBuilder = builderMethod.invoke(null, new Object[0]);
        logger.debug("obtained cliBuilder", new Object[0]);
        return cliBuilder;
    }

    private Object getRunnerBuilder(Class<?> builderProviderImplClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = builderProviderImplClass.getDeclaredConstructor(new Class[0]);
        Object builderProvider = constructor.newInstance(new Object[0]);
        Method getBuilderMethod = builderProvider.getClass().getMethod("getBuilder", new Class[0]);
        return getBuilderMethod.invoke(builderProvider, new Object[0]);
    }

    private URLClassLoader buildClassLoader() throws MalformedURLException {
        return URLClassLoader.newInstance(new URL[]{new URL(String.format("jar:file:%s!/", this.appJar)), new URL(String.format("jar:file:%s!/", this.cliJar))}, Thread.currentThread().getContextClassLoader());
    }
}

