/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.util.logger;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.Attribute;
import io.mongock.cli.util.logger.CliLogger;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class CliLoggerFactory {
    private static final int CLASS_NAME_LIMIT = 40;
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    private CliLoggerFactory() {
    }

    public static CliLogger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public static void setLevel(CliLogger.Level level) {
        Logger.setLevel(level);
    }

    public static class Logger
    implements CliLogger {
        private static final String pid = Logger.getProcessId("<PID>");
        private static CliLogger.Level level = CliLogger.Level.INFO;
        private final String className;

        static void setLevel(CliLogger.Level newLevel) {
            level = newLevel;
        }

        Logger(Class<?> targetClass) {
            this.className = targetClass.getName();
        }

        private boolean shouldLog(CliLogger.Level targetLevel) {
            return targetLevel.isGreaterEqual(level);
        }

        @Override
        public void print(CliLogger.Level level, String format, Object ... arguments) {
            if (this.shouldLog(level)) {
                String newFormat = format.contains("{}") ? format.replaceAll("\\{}", "%s") : format;
                String message = String.format(newFormat, arguments);
                String time = Ansi.colorize(LocalDateTime.now().format(timeFormatter), Attribute.WHITE_TEXT());
                String pidColored = Ansi.colorize(pid, Attribute.MAGENTA_TEXT());
                String levelMsg = this.getColoredLevel(level);
                PrintStream out = level.isGreaterEqual(CliLogger.Level.ERROR) ? System.err : System.out;
                String application = Ansi.colorize("--- [    mongock-cli]", Attribute.WHITE_TEXT());
                String classColored = this.getFormattedClassName(this.className);
                String colon = Ansi.colorize(" : ", Attribute.WHITE_TEXT());
                out.println(time + " " + levelMsg + " " + pidColored + " " + application + " " + classColored + colon + message);
            }
        }

        private String getFormattedClassName(String classname) {
            String finalClassName = this.className;
            if (classname.length() > 40) {
                CharSequence[] split = classname.split("\\.");
                for (int i = 0; i < split.length; ++i) {
                    split[i] = String.valueOf(split[i].charAt(0));
                    finalClassName = String.join((CharSequence)".", split);
                    if (finalClassName.length() <= 40) break;
                }
            }
            return Ansi.colorize(String.format("%-40s", finalClassName), Attribute.CYAN_TEXT());
        }

        private String getColoredLevel(CliLogger.Level level) {
            switch (level) {
                case ERROR: {
                    return Ansi.colorize(level.name(), Attribute.RED_TEXT());
                }
                case INFO: {
                    return " " + Ansi.colorize(level.name(), Attribute.GREEN_TEXT());
                }
                case WARN: {
                    return " " + Ansi.colorize(level.name(), Attribute.YELLOW_TEXT());
                }
                case DEBUG: {
                    return Ansi.colorize(level.name(), Attribute.BLUE_TEXT());
                }
                case TRACE: {
                    return Ansi.colorize(level.name(), Attribute.CYAN_TEXT());
                }
            }
            return level.name();
        }

        private static String getProcessId(String defaultValue) {
            int index;
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            int n = index = jvmName != null ? jvmName.indexOf(64) : -1;
            if (index < 1) {
                return defaultValue;
            }
            try {
                return Long.toString(Long.parseLong(jvmName.substring(0, index)));
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }
}

