/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.internal;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.api.util.ChangePrintable;
import io.mongock.runner.core.internal.BeforeChangeSetItem;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

public class ChangeSetItem
implements ChangePrintable {
    private final String id;
    private final String author;
    private final String order;
    private final boolean runAlways;
    private final String systemVersion;
    private final Method method;
    private final boolean failFast;
    private final Method rollbackMethod;

    public ChangeSetItem(String id, String author, String order, boolean runAlways, String systemVersion, boolean failFast, Method changeSetMethod, Method rollbackMethod) {
        if (id == null || id.trim().isEmpty()) {
            throw new MongockException("id cannot be null or empty.");
        }
        if (author == null) {
            throw new MongockException("author cannot be null.");
        }
        this.id = id;
        this.author = author;
        this.order = order;
        this.runAlways = runAlways;
        this.systemVersion = systemVersion;
        this.method = changeSetMethod;
        this.failFast = failFast;
        this.rollbackMethod = rollbackMethod;
    }

    public String getId() {
        return this.id;
    }

    public ChangeType getType() {
        return this instanceof BeforeChangeSetItem ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getChangeLogClassString() {
        return this.method.getDeclaringClass().getSimpleName();
    }

    public String getMethodNameString() {
        return this.method.getName();
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public Optional<Method> getRollbackMethod() {
        return Optional.ofNullable(this.rollbackMethod);
    }

    public boolean isBeforeChangeSets() {
        return this instanceof BeforeChangeSetItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSetItem that = (ChangeSetItem)o;
        return this.id.equals(that.id) && Objects.equals(this.author, that.author);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.author);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChangeSetItem{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", author='").append(this.author).append('\'');
        sb.append(", order='").append(this.order).append('\'');
        sb.append(", runAlways=").append(this.runAlways);
        sb.append(", systemVersion='").append(this.systemVersion).append('\'');
        sb.append(", method=").append(this.method);
        sb.append(", failFast=").append(this.failFast);
        sb.append(", rollbackMethod=").append(this.rollbackMethod);
        sb.append('}');
        return sb.toString();
    }
}

