/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper.util;

import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ArgsUtil {
    private static final CliLogger logger = CliLoggerFactory.getLogger(ArgsUtil.class);

    private ArgsUtil() {
    }

    public static String[] getCleanArgs(String[] args, String ... paramNames) {
        StringBuilder sb = new StringBuilder("cleaning arguments: ");
        Set paramNamesSet = Stream.of(paramNames).peek(arg -> sb.append((String)arg).append(" ")).map(String::toLowerCase).collect(Collectors.toSet());
        logger.debug(sb.toString(), new Object[0]);
        ArrayList<String> tempNewArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!paramNamesSet.contains(args[i].toLowerCase())) {
                tempNewArgs.add(args[i]);
                continue;
            }
            ++i;
        }
        String[] newArgs = new String[tempNewArgs.size()];
        tempNewArgs.toArray(newArgs);
        logger.debug("cleaned args size: " + newArgs.length, new Object[0]);
        StringBuilder sb2 = new StringBuilder("cleaned args: ");
        Stream.of(newArgs).forEach(arg -> sb2.append((String)arg).append(" "));
        logger.debug(sb2.toString(), new Object[0]);
        return newArgs;
    }

    public static Optional<String> getOptionalParam(String[] args, String paramName) {
        return Optional.ofNullable(ArgsUtil.getParameter(args, paramName, false));
    }

    public static String getParameter(String[] args, String paramName) {
        return ArgsUtil.getParameter(args, paramName, true);
    }

    public static String getParameter(String[] args, String paramName, boolean throwException) {
        int i = 0;
        do {
            if (!paramName.equalsIgnoreCase(args[i])) continue;
            if (args.length == i + 1) {
                if (throwException) {
                    throw new RuntimeException(String.format("Found [%s] flag with missing value. Please follow the format \"%s value\"", paramName, paramName));
                }
                return null;
            }
            return args[i + 1];
        } while (++i < args.length);
        if (throwException) {
            throw new RuntimeException(String.format("Missing jar parameter. Please follow the format \"%s jar_path\"", paramName));
        }
        return null;
    }
}

