/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.core.commands.undo;

import io.mongock.cli.core.VersionProvider;
import io.mongock.cli.core.commands.CommandBase;
import io.mongock.cli.core.commands.ProfessionalOperationProxy;
import io.mongock.runner.core.builder.RunnerBuilder;
import io.mongock.runner.core.executor.MongockRunner;
import picocli.CommandLine;

@CommandLine.Command(name="undo", description={"(pro) - Reverts the applied migration (./mongock undo -h for more details)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class UndoCommand
extends CommandBase<Integer> {
    @CommandLine.Parameters(index="0", description={"  ChangeUnit id   up to which Mongock will rollback(inclusive)."})
    private String changeId;

    public UndoCommand(RunnerBuilder builder) {
        super(builder);
    }

    @Override
    public Integer call() {
        MongockRunner mongockRunner = this.builder.buildRunner(ProfessionalOperationProxy.undoOp(this.changeId));
        mongockRunner.forceEnable();
        mongockRunner.execute();
        return 0;
    }
}

