/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.changelog;

import com.github.cloudyrock.mongock.ChangeLog;
import io.mongock.api.annotations.ChangeUnit;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.Validable;
import io.mongock.runner.core.annotation.AnnotationProcessor;
import io.mongock.runner.core.annotation.LegacyAnnotationProcessor;
import io.mongock.runner.core.executor.changelog.ChangeLogComparator;
import io.mongock.runner.core.executor.changelog.ChangeSetComparator;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.runner.core.internal.ChangeSetItem;
import io.mongock.utils.CollectionUtils;
import io.mongock.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.reflections.Reflections;

public abstract class ChangeLogServiceBase<CHANGELOG extends ChangeLogItem<CHANGESET>, CHANGESET extends ChangeSetItem>
implements Validable {
    private final LegacyAnnotationProcessor<CHANGESET> legacyAnnotationProcessor;
    private final AnnotationProcessor annotationProcessor;
    protected Function<AnnotatedElement, Boolean> profileFilter;
    private Function<Class<?>, Object> changeLogInstantiator;
    private List<String> changeLogsBasePackageList = Collections.emptyList();
    private List<Class<?>> changeLogsBaseClassList = Collections.emptyList();
    private ArtifactVersion startSystemVersion = new DefaultArtifactVersion("0");
    private ArtifactVersion endSystemVersion = new DefaultArtifactVersion(String.valueOf(Integer.MAX_VALUE));
    private String defaultMigrationAuthor = null;

    public ChangeLogServiceBase(AnnotationProcessor annotationProcessor, LegacyAnnotationProcessor<CHANGESET> legacyAnnotationProcessor) {
        this.legacyAnnotationProcessor = legacyAnnotationProcessor;
        this.annotationProcessor = annotationProcessor;
    }

    protected LegacyAnnotationProcessor<CHANGESET> getLegacyAnnotationProcessor() {
        return this.legacyAnnotationProcessor;
    }

    protected AnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    protected List<String> getChangeLogsBasePackageList() {
        return this.changeLogsBasePackageList;
    }

    public void setChangeLogsBasePackageList(List<String> changeLogsBasePackageList) {
        this.changeLogsBasePackageList = changeLogsBasePackageList;
    }

    protected List<Class<?>> getChangeLogsBaseClassList() {
        return this.changeLogsBaseClassList;
    }

    public void setChangeLogsBaseClassList(List<Class<?>> changeLogsBaseClassList) {
        this.changeLogsBaseClassList = changeLogsBaseClassList;
    }

    protected ArtifactVersion getStartSystemVersion() {
        return this.startSystemVersion;
    }

    public void setStartSystemVersion(String startSystemVersion) {
        this.startSystemVersion = new DefaultArtifactVersion(startSystemVersion);
    }

    protected ArtifactVersion getEndSystemVersion() {
        return this.endSystemVersion;
    }

    public void setEndSystemVersion(String endSystemVersion) {
        this.endSystemVersion = new DefaultArtifactVersion(endSystemVersion);
    }

    protected Function<AnnotatedElement, Boolean> getProfileFilter() {
        return this.profileFilter;
    }

    public void setProfileFilter(Function<AnnotatedElement, Boolean> profileFilter) {
        this.profileFilter = profileFilter;
    }

    protected Optional<Function<Class<?>, Object>> getChangeLogInstantiator() {
        return Optional.ofNullable(this.changeLogInstantiator);
    }

    public String getDefaultMigrationAuthor() {
        return this.defaultMigrationAuthor;
    }

    public void setDefaultMigrationAuthor(String defaultMigrationAuthor) {
        this.defaultMigrationAuthor = defaultMigrationAuthor;
    }

    @Override
    public void runValidation() throws MongockException {
        if ((CollectionUtils.isNullEmpty(this.changeLogsBasePackageList) || !this.changeLogsBasePackageList.stream().allMatch(StringUtils::hasText)) && CollectionUtils.isNullEmpty(this.changeLogsBaseClassList)) {
            throw new MongockException("Scan package for changeLogs is not set: use appropriate setter");
        }
    }

    public SortedSet<CHANGELOG> fetchChangeLogs() {
        TreeSet changeLogs = this.mergeChangeLogClassesAndPackages().stream().filter(changeLogClass -> this.profileFilter != null ? this.profileFilter.apply((AnnotatedElement)changeLogClass) : true).filter(changeLogClass -> !changeLogClass.isAnnotationPresent(ChangeUnit.class) || this.isWithinVersion(changeLogClass.getAnnotation(ChangeUnit.class).systemVersion())).map(this::buildChangeLogObject).collect(Collectors.toCollection(() -> new TreeSet(new ChangeLogComparator())));
        this.validateDuplications(changeLogs);
        return changeLogs;
    }

    private void validateDuplications(Set<CHANGELOG> changeLogs) {
        ThrowableHashSet allChangeSets = new ThrowableHashSet();
        changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).forEach(allChangeSets::addAndThrow);
    }

    private Set<Class<?>> mergeChangeLogClassesAndPackages() {
        Stream scannedPackageStream = this.changeLogsBasePackageList != null && !this.changeLogsBasePackageList.isEmpty() ? Stream.concat(new Reflections(this.changeLogsBasePackageList).getTypesAnnotatedWith(ChangeLog.class).stream(), new Reflections(this.changeLogsBasePackageList).getTypesAnnotatedWith(ChangeUnit.class).stream()) : Stream.empty();
        return Stream.concat(this.changeLogsBaseClassList.stream(), scannedPackageStream).collect(Collectors.toSet());
    }

    protected List<CHANGESET> fetchChangeSetMethodsSorted(Class<?> type) throws MongockException {
        List<CHANGESET> changeSets = this.getChangeSetWithCompanionMethods(Arrays.asList(type.getDeclaredMethods()));
        changeSets.sort(new ChangeSetComparator());
        return changeSets;
    }

    private List<CHANGESET> getChangeSetWithCompanionMethods(List<Method> allMethods) throws MongockException {
        HashSet changeSetIdsAlreadyProcessed = new HashSet();
        Consumer<String> addIfNotDuplicatedOrException = changeSetId -> {
            if (changeSetIdsAlreadyProcessed.contains(changeSetId)) {
                throw new MongockException(String.format("Duplicated changeset id found: '%s'", changeSetId));
            }
            changeSetIdsAlreadyProcessed.add(changeSetId);
        };
        return allMethods.stream().filter(this.legacyAnnotationProcessor::isMethodAnnotatedAsChange).map(changeSetMethod -> this.legacyAnnotationProcessor.getChangePerformerItem((Method)changeSetMethod, null)).peek(changeSetItem -> addIfNotDuplicatedOrException.accept(changeSetItem.getId())).filter(changeSetItem -> this.isWithinVersion(changeSetItem.getSystemVersion())).collect(Collectors.toList());
    }

    private boolean isWithinVersion(String versionString) {
        DefaultArtifactVersion version = new DefaultArtifactVersion(versionString);
        return version.compareTo(this.startSystemVersion) >= 0 && version.compareTo(this.endSystemVersion) <= 0;
    }

    private CHANGELOG buildChangeLogObject(Class<?> changeLogClass) {
        try {
            return !changeLogClass.isAnnotationPresent(ChangeUnit.class) ? this.buildChangeLogInstanceFromLegacy(changeLogClass) : this.buildChangeLogInstance(changeLogClass);
        }
        catch (MongockException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MongockException(ex);
        }
    }

    protected abstract CHANGELOG buildChangeLogInstance(Class<?> var1) throws MongockException;

    protected abstract CHANGELOG buildChangeLogInstanceFromLegacy(Class<?> var1) throws MongockException;

    protected List<CHANGESET> fetchListOfChangeSetsFromClass(Class<?> type) {
        return this.getAllChanges(type).filter(changeSetItem -> this.getLegacyAnnotationProcessor().isChangeSet(changeSetItem.getMethod())).collect(Collectors.toList());
    }

    private Stream<CHANGESET> getAllChanges(Class<?> type) {
        return this.fetchChangeSetMethodsSorted(type).stream().filter(changeSet -> this.profileFilter != null ? this.profileFilter.apply(changeSet.getMethod()) : true);
    }

    private class ThrowableHashSet
    extends HashSet<ChangeSetItem> {
        private ThrowableHashSet() {
        }

        public void addAndThrow(ChangeSetItem e) {
            if (!this.add(e)) {
                throw new MongockException("Change with id[%s] duplicated", e.getId());
            }
        }
    }
}

