/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;

public class NettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public NettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(NettyReactiveWebServerFactory factory) {
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
        propertyMapper.from(nettyProperties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        this.customizeRequestDecoder(factory, propertyMapper);
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeConnectionTimeout(NettyReactiveWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(httpServer -> (HttpServer)httpServer.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())));
    }

    private void customizeRequestDecoder(NettyReactiveWebServerFactory factory, PropertyMapper propertyMapper) {
        factory.addServerCustomizers(httpServer -> httpServer.httpRequestDecoder(httpRequestDecoderSpec -> {
            propertyMapper.from(this.serverProperties.getMaxHttpHeaderSize()).whenNonNull().to(maxHttpRequestHeader -> {
                HttpRequestDecoderSpec cfr_ignored_0 = (HttpRequestDecoderSpec)httpRequestDecoderSpec.maxHeaderSize((int)maxHttpRequestHeader.toBytes());
            });
            ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
            propertyMapper.from(nettyProperties.getMaxChunkSize()).whenNonNull().to(maxChunkSize -> {
                HttpRequestDecoderSpec cfr_ignored_0 = (HttpRequestDecoderSpec)httpRequestDecoderSpec.maxChunkSize((int)maxChunkSize.toBytes());
            });
            propertyMapper.from(nettyProperties.getMaxInitialLineLength()).whenNonNull().to(maxInitialLineLength -> {
                HttpRequestDecoderSpec cfr_ignored_0 = (HttpRequestDecoderSpec)httpRequestDecoderSpec.maxInitialLineLength((int)maxInitialLineLength.toBytes());
            });
            propertyMapper.from(nettyProperties.getH2cMaxContentLength()).whenNonNull().to(h2cMaxContentLength -> {
                HttpRequestDecoderSpec cfr_ignored_0 = (HttpRequestDecoderSpec)httpRequestDecoderSpec.h2cMaxContentLength((int)h2cMaxContentLength.toBytes());
            });
            propertyMapper.from(nettyProperties.getInitialBufferSize()).whenNonNull().to(initialBufferSize -> {
                HttpRequestDecoderSpec cfr_ignored_0 = (HttpRequestDecoderSpec)httpRequestDecoderSpec.initialBufferSize((int)initialBufferSize.toBytes());
            });
            propertyMapper.from(nettyProperties.isValidateHeaders()).whenNonNull().to(arg_0 -> ((HttpRequestDecoderSpec)httpRequestDecoderSpec).validateHeaders(arg_0));
            return httpRequestDecoderSpec;
        }));
    }
}

