/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.util.StringUtils;

class StandardConfigDataReference {
    private final ConfigDataLocation configDataLocation;
    private final String resourceLocation;
    private final String directory;
    private final String profile;
    private final PropertySourceLoader propertySourceLoader;

    StandardConfigDataReference(ConfigDataLocation configDataLocation, String directory, String root, String profile2, String extension, PropertySourceLoader propertySourceLoader) {
        this.configDataLocation = configDataLocation;
        String profileSuffix = StringUtils.hasText(profile2) ? "-" + profile2 : "";
        this.resourceLocation = root + profileSuffix + (extension != null ? "." + extension : "");
        this.directory = directory;
        this.profile = profile2;
        this.propertySourceLoader = propertySourceLoader;
    }

    ConfigDataLocation getConfigDataLocation() {
        return this.configDataLocation;
    }

    String getResourceLocation() {
        return this.resourceLocation;
    }

    boolean isNonOptionalDirectory() {
        return !this.configDataLocation.isOptional() && this.directory != null;
    }

    String getDirectory() {
        return this.directory;
    }

    boolean isSkippable() {
        return this.configDataLocation.isOptional() || this.directory != null || this.profile != null;
    }

    PropertySourceLoader getPropertySourceLoader() {
        return this.propertySourceLoader;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StandardConfigDataReference other = (StandardConfigDataReference)obj;
        return this.resourceLocation.equals(other.resourceLocation);
    }

    public int hashCode() {
        return this.resourceLocation.hashCode();
    }

    public String toString() {
        return this.resourceLocation;
    }
}

