/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.ClassUtils;

public final class DataSourceBuilder<T extends DataSource> {
    private Class<? extends DataSource> type;
    private final DataSourceSettingsResolver settingsResolver;
    private final Map<String, String> properties = new HashMap<String, String>();

    public static DataSourceBuilder<?> create() {
        return new DataSourceBuilder(null);
    }

    public static DataSourceBuilder<?> create(ClassLoader classLoader) {
        return new DataSourceBuilder(classLoader);
    }

    private DataSourceBuilder(ClassLoader classLoader) {
        this.settingsResolver = new DataSourceSettingsResolver(classLoader);
    }

    public T build() {
        Class<DataSource> type = this.getType();
        DataSource result = BeanUtils.instantiateClass(type);
        this.maybeGetDriverClassName();
        this.bind(result);
        return (T)result;
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl(url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
        }
    }

    private void bind(DataSource result) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(this.properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        this.settingsResolver.registerAliases(result, aliases);
        Binder binder = new Binder(source.withAliases(aliases));
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance(result));
    }

    public <D extends DataSource> DataSourceBuilder<D> type(Class<D> type) {
        this.type = type;
        return this;
    }

    public DataSourceBuilder<T> url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DataSourceBuilder<T> driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public DataSourceBuilder<T> username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DataSourceBuilder<T> password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public static Class<? extends DataSource> findType(ClassLoader classLoader) {
        DataSourceSettings preferredDataSourceSettings = new DataSourceSettingsResolver(classLoader).getPreferredDataSourceSettings();
        return preferredDataSourceSettings != null ? preferredDataSourceSettings.getType() : null;
    }

    private Class<? extends DataSource> getType() {
        if (this.type != null) {
            return this.type;
        }
        DataSourceSettings preferredDataSourceSettings = this.settingsResolver.getPreferredDataSourceSettings();
        if (preferredDataSourceSettings != null) {
            return preferredDataSourceSettings.getType();
        }
        throw new IllegalStateException("No supported DataSource type found");
    }

    private static class DataSourceSettingsResolver {
        private final DataSourceSettings preferredDataSourceSettings;
        private final List<DataSourceSettings> allDataSourceSettings;

        DataSourceSettingsResolver(ClassLoader classLoader) {
            List<DataSourceSettings> supportedProviders = DataSourceSettingsResolver.resolveAvailableDataSourceSettings(classLoader);
            this.preferredDataSourceSettings = !supportedProviders.isEmpty() ? supportedProviders.get(0) : null;
            this.allDataSourceSettings = new ArrayList<DataSourceSettings>(supportedProviders);
            DataSourceSettingsResolver.addIfAvailable(this.allDataSourceSettings, DataSourceSettingsResolver.create(classLoader, "org.springframework.jdbc.datasource.SimpleDriverDataSource", type -> new DataSourceSettings((Class<? extends DataSource>)type, aliases -> aliases.addAliases("driver-class-name", "driver-class"))));
            DataSourceSettingsResolver.addIfAvailable(this.allDataSourceSettings, DataSourceSettingsResolver.create(classLoader, "oracle.jdbc.datasource.OracleDataSource", OracleDataSourceSettings::new));
        }

        private static List<DataSourceSettings> resolveAvailableDataSourceSettings(ClassLoader classLoader) {
            ArrayList<DataSourceSettings> providers = new ArrayList<DataSourceSettings>();
            DataSourceSettingsResolver.addIfAvailable(providers, DataSourceSettingsResolver.create(classLoader, "com.zaxxer.hikari.HikariDataSource", type -> new DataSourceSettings((Class<? extends DataSource>)type, aliases -> aliases.addAliases("url", "jdbc-url"))));
            DataSourceSettingsResolver.addIfAvailable(providers, DataSourceSettingsResolver.create(classLoader, "org.apache.tomcat.jdbc.pool.DataSource", DataSourceSettings::new));
            DataSourceSettingsResolver.addIfAvailable(providers, DataSourceSettingsResolver.create(classLoader, "org.apache.commons.dbcp2.BasicDataSource", DataSourceSettings::new));
            DataSourceSettingsResolver.addIfAvailable(providers, DataSourceSettingsResolver.create(classLoader, "oracle.ucp.jdbc.PoolDataSourceImpl", type -> {
                if (ClassUtils.isPresent("oracle.jdbc.OracleConnection", classLoader)) {
                    return new DataSourceSettings((Class<? extends DataSource>)type, aliases -> {
                        aliases.addAliases("username", "user");
                        aliases.addAliases("driver-class-name", "connection-factory-class-name");
                    });
                }
                return null;
            }));
            return providers;
        }

        private static DataSourceSettings create(ClassLoader classLoader, String target, Function<Class<? extends DataSource>, DataSourceSettings> factory) {
            if (ClassUtils.isPresent(target, classLoader)) {
                try {
                    Class<?> type = ClassUtils.forName(target, classLoader);
                    return factory.apply(type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private static void addIfAvailable(Collection<DataSourceSettings> list, DataSourceSettings dataSourceSettings) {
            if (dataSourceSettings != null) {
                list.add(dataSourceSettings);
            }
        }

        DataSourceSettings getPreferredDataSourceSettings() {
            return this.preferredDataSourceSettings;
        }

        void registerAliases(DataSource result, ConfigurationPropertyNameAliases aliases) {
            this.allDataSourceSettings.forEach(settings -> settings.registerAliases(result, aliases));
        }
    }

    private static class OracleDataSourceSettings
    extends DataSourceSettings {
        OracleDataSourceSettings(Class<? extends DataSource> type) {
            super(type, aliases -> aliases.addAliases("username", "user"));
        }

        @Override
        public Class<? extends DataSource> getType() {
            return null;
        }
    }

    private static class DataSourceSettings {
        private final Class<? extends DataSource> type;
        private final Consumer<ConfigurationPropertyNameAliases> aliasesCustomizer;

        DataSourceSettings(Class<? extends DataSource> type, Consumer<ConfigurationPropertyNameAliases> aliasesCustomizer) {
            this.type = type;
            this.aliasesCustomizer = aliasesCustomizer;
        }

        DataSourceSettings(Class<? extends DataSource> type) {
            this(type, aliases -> {});
        }

        Class<? extends DataSource> getType() {
            return this.type;
        }

        void registerAliases(DataSource candidate, ConfigurationPropertyNameAliases aliases) {
            if (this.type != null && this.type.isInstance(candidate)) {
                this.aliasesCustomizer.accept(aliases);
            }
        }
    }
}

