/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import java.io.FileNotFoundException;
import liquibase.exception.ChangeLogParseException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.StringUtils;

class LiquibaseChangelogMissingFailureAnalyzer
extends AbstractFailureAnalyzer<ChangeLogParseException> {
    LiquibaseChangelogMissingFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, ChangeLogParseException cause) {
        String changelogPath;
        FileNotFoundException fileNotFound = this.findCause((Throwable)cause, FileNotFoundException.class);
        if (fileNotFound != null && StringUtils.hasText(changelogPath = this.extractChangelogPath(cause))) {
            return new FailureAnalysis(this.getDescription(changelogPath), "Make sure a Liquibase changelog is present at the configured path.", (Throwable)cause);
        }
        return null;
    }

    private String extractChangelogPath(ChangeLogParseException cause) {
        return cause.getMessage().substring("Error parsing ".length());
    }

    private String getDescription(String changelogPath) {
        return "Liquibase failed to start because no changelog could be found at '" + changelogPath + "'.";
    }
}

