/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.builder;

import io.mongock.api.config.LegacyMigration;
import io.mongock.api.config.MongockConfiguration;
import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.driver.DriverLegaciable;
import io.mongock.runner.core.builder.BuilderType;
import io.mongock.runner.core.event.EventPublisher;
import io.mongock.runner.core.executor.ChangeLogRuntimeImpl;
import io.mongock.runner.core.executor.Executor;
import io.mongock.runner.core.executor.ExecutorBuilder;
import io.mongock.runner.core.executor.MongockRunner;
import io.mongock.runner.core.executor.MongockRunnerImpl;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.executor.dependency.DependencyManager;
import io.mongock.runner.core.executor.operation.Operation;
import io.mongock.runner.core.executor.operation.migrate.MigrateAllOperation;
import io.mongock.utils.MongockCommunityProperties;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunnerBuilderBase<SELF extends RunnerBuilderBase<SELF, CONFIG>, CONFIG extends MongockConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(RunnerBuilderBase.class);
    protected final CONFIG config;
    protected final ExecutorBuilder<CONFIG> executorBuilder;
    protected final ChangeLogServiceBase changeLogService;
    protected final DependencyManager dependencyManager;
    private final BuilderType type;
    protected EventPublisher eventPublisher = new EventPublisher();
    protected ConnectionDriver driver;
    protected Function<Class<?>, Object> changeLogInstantiatorFunctionForAnnotations;
    protected Function<Parameter, String> parameterNameFunction = parameter -> parameter.isAnnotationPresent(Named.class) ? parameter.getAnnotation(Named.class).value() : null;
    private String executionId = String.format("%s-%d", LocalDateTime.now(), new Random().nextInt(999));

    protected RunnerBuilderBase(BuilderType type, ExecutorBuilder<CONFIG> executorBuilder, ChangeLogServiceBase changeLogService, DependencyManager dependencyManager, CONFIG config) {
        this.executorBuilder = executorBuilder;
        this.changeLogService = changeLogService;
        this.dependencyManager = dependencyManager;
        this.config = config;
        this.type = type;
    }

    public BuilderType getType() {
        return this.type;
    }

    public String getVersion() {
        return MongockCommunityProperties.VERSION;
    }

    public SELF setExecutionId(String executionId) {
        this.executionId = executionId;
        return this.getInstance();
    }

    @Deprecated
    public SELF setChangeLogInstantiator(Function<Class<?>, Object> changeLogInstantiator) {
        this.changeLogInstantiatorFunctionForAnnotations = changeLogInstantiator;
        return this.getInstance();
    }

    public CONFIG getConfig() {
        return this.config;
    }

    public SELF setConfig(CONFIG newConfig) {
        ((MongockConfiguration)this.config).updateFrom((MongockConfiguration)newConfig);
        return this.getInstance();
    }

    public SELF setDriver(ConnectionDriver driver) {
        this.driver = driver;
        return this.getInstance();
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public SELF setTransactionStrategy(TransactionStrategy transactionStrategy) {
        ((MongockConfiguration)this.config).setTransactionStrategy(transactionStrategy);
        return this.getInstance();
    }

    public SELF setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        return this.getInstance();
    }

    public MongockRunner buildRunner() {
        return this.buildRunner(new MigrateAllOperation());
    }

    public MongockRunner buildRunner(Operation operation) {
        return this.buildRunner(operation, this.driver);
    }

    protected MongockRunner buildRunner(ConnectionDriver driver) {
        return this.buildRunner(new MigrateAllOperation(), driver);
    }

    protected MongockRunner buildRunner(Operation operation, ConnectionDriver driver) {
        logger.info("Mongock runner {} version[{}]", (Object)this.getType(), (Object)this.getVersion());
        this.validateConfigurationAndInjections(driver);
        try {
            this.beforeBuildRunner(driver);
            return new MongockRunnerImpl(this.buildExecutor(operation, driver), ((MongockConfiguration)this.config).isThrowExceptionIfCannotObtainLock(), ((MongockConfiguration)this.config).isEnabled(), this.eventPublisher);
        }
        catch (MongockException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MongockException(ex);
        }
    }

    protected void beforeBuildRunner(ConnectionDriver driver) {
        DriverLegaciable legaciableDriver;
        if (((MongockConfiguration)this.config).getLegacyMigration() != null && (legaciableDriver = this.getDriverLegaciable(driver)) != null) {
            ((MongockConfiguration)this.config).getMigrationScanPackage().add(legaciableDriver.getLegacyMigrationChangeLogClass(((MongockConfiguration)this.config).getLegacyMigration().isRunAlways()).getPackage().getName());
            this.dependencyManager.addStandardDependency(new ChangeSetDependency("legacy-migration", LegacyMigration.class, ((MongockConfiguration)this.config).getLegacyMigration()));
        }
        driver.setLockRepositoryName(((MongockConfiguration)this.config).getLockRepositoryName());
        driver.setMigrationRepositoryName(((MongockConfiguration)this.config).getMigrationRepositoryName());
    }

    private void prepareChangeLogService() {
        ArrayList changeLogsScanClasses = new ArrayList();
        ArrayList<String> changeLogsScanPackage = new ArrayList<String>();
        for (String itemPath : ((MongockConfiguration)this.config).getMigrationScanPackage()) {
            try {
                changeLogsScanClasses.add(ClassLoader.getSystemClassLoader().loadClass(itemPath));
            }
            catch (ClassNotFoundException e) {
                changeLogsScanPackage.add(itemPath);
            }
        }
        this.changeLogService.setDefaultMigrationAuthor(((MongockConfiguration)this.config).getDefaultMigrationAuthor());
        this.changeLogService.setChangeLogsBasePackageList(changeLogsScanPackage);
        this.changeLogService.setChangeLogsBaseClassList(changeLogsScanClasses);
        this.changeLogService.setStartSystemVersion(((MongockConfiguration)this.config).getStartSystemVersion());
        this.changeLogService.setEndSystemVersion(((MongockConfiguration)this.config).getEndSystemVersion());
        this.changeLogService.setProfileFilter(this.getAnnotationFilter());
    }

    protected void validateConfigurationAndInjections(ConnectionDriver driver) throws MongockException {
        if (driver == null) {
            throw new MongockException("Driver must be injected to Mongock builder");
        }
        if (!((MongockConfiguration)this.config).isThrowExceptionIfCannotObtainLock()) {
            logger.warn("throwExceptionIfCannotObtainLock is disabled, which means Mongock will continue even if it's not able to acquire the lock");
        }
        if (!"0".equals(((MongockConfiguration)this.config).getStartSystemVersion()) || !String.valueOf(Integer.MAX_VALUE).equals(((MongockConfiguration)this.config).getEndSystemVersion())) {
            logger.info("Running Mongock with startSystemVersion[{}] and endSystemVersion[{}]", (Object)((MongockConfiguration)this.config).getStartSystemVersion(), (Object)((MongockConfiguration)this.config).getEndSystemVersion());
        }
        if (((MongockConfiguration)this.config).getMetadata() == null) {
            logger.info("Running Mongock with NO metadata");
        } else {
            logger.info("Running Mongock with metadata");
        }
        if (((MongockConfiguration)this.config).getTransactionEnabled().isPresent()) {
            boolean transactionEnabled = ((MongockConfiguration)this.config).getTransactionEnabled().get();
            if (transactionEnabled && !driver.isTransactionable()) {
                throw new MongockException("Property transaction-enabled=true, but transactionManager not provided");
            }
            if (!transactionEnabled && driver.isTransactionable()) {
                logger.warn("Property transaction-enabled=false, but driver is transactionable");
            }
        } else {
            logger.warn("Property transaction-enabled not provided. It will become true as default in next versions. Set explicit value to false in case transaction are not desired.");
            if (driver.isTransactionable()) {
                logger.warn("Property transaction-enabled not provided, but driver is transactionable. BY DEFAULT MONGOCK WILL RUN IN TRANSACTION MODE.");
            } else {
                logger.warn("Property transaction-enabled not provided and is unknown if driver is transactionable. BY DEFAULT MONGOCK WILL RUN IN NO-TRANSACTION MODE.");
            }
        }
    }

    protected Function<AnnotatedElement, Boolean> getAnnotationFilter() {
        return annotatedElement -> true;
    }

    protected DriverLegaciable getDriverLegaciable(ConnectionDriver driver) {
        return driver != null && DriverLegaciable.class.isAssignableFrom(driver.getClass()) ? (DriverLegaciable)((Object)driver) : null;
    }

    protected Executor buildExecutor(Operation operation, ConnectionDriver driver) {
        this.prepareChangeLogService();
        ChangeLogRuntimeImpl changeLogRuntime = new ChangeLogRuntimeImpl(this.changeLogInstantiatorFunctionForAnnotations, this.dependencyManager, this.parameterNameFunction, driver.getNonProxyableTypes());
        return this.executorBuilder.setOperation(operation).setExecutionId(this.executionId).setChangeLogService(this.changeLogService).setDriver(driver).setChangeLogRuntime(changeLogRuntime).setConfig(this.config).buildExecutor();
    }

    public abstract SELF getInstance();
}

