/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class Profiles
implements Iterable<String> {
    public static final String INCLUDE_PROFILES_PROPERTY_NAME = "spring.profiles.include";
    private static final Bindable<MultiValueMap<String, String>> STRING_STRINGS_MAP = Bindable.of(ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, String.class));
    private static final Set<String> UNSET_ACTIVE = Collections.emptySet();
    private static final Set<String> UNSET_DEFAULT = Collections.singleton("default");
    private final MultiValueMap<String, String> groups;
    private final List<String> activeProfiles;
    private final List<String> defaultProfiles;

    Profiles(Environment environment2, Binder binder, Collection<String> additionalProfiles) {
        this.groups = binder.bind("spring.profiles.group", STRING_STRINGS_MAP).orElseGet(LinkedMultiValueMap::new);
        this.activeProfiles = this.expandProfiles(this.getActivatedProfiles(environment2, binder, additionalProfiles));
        this.defaultProfiles = this.expandProfiles(this.getDefaultProfiles(environment2, binder));
    }

    private List<String> getActivatedProfiles(Environment environment2, Binder binder, Collection<String> additionalProfiles) {
        return this.asUniqueItemList(this.get(environment2, binder, environment2::getActiveProfiles, "spring.profiles.active", UNSET_ACTIVE), additionalProfiles);
    }

    private List<String> getDefaultProfiles(Environment environment2, Binder binder) {
        return this.asUniqueItemList(this.get(environment2, binder, environment2::getDefaultProfiles, "spring.profiles.default", UNSET_DEFAULT));
    }

    private String[] get(Environment environment2, Binder binder, Supplier<String[]> supplier, String propertyName, Set<String> unset) {
        String propertyValue = environment2.getProperty(propertyName);
        if (this.hasExplicit(supplier, propertyValue, unset)) {
            return supplier.get();
        }
        return binder.bind(propertyName, String[].class).orElse(StringUtils.toStringArray(unset));
    }

    private boolean hasExplicit(Supplier<String[]> supplier, String propertyValue, Set<String> unset) {
        LinkedHashSet<Object> profiles = new LinkedHashSet<Object>(Arrays.asList((Object[])supplier.get()));
        if (!StringUtils.hasLength(propertyValue)) {
            return !unset.equals(profiles);
        }
        Set<String> propertyProfiles = StringUtils.commaDelimitedListToSet(StringUtils.trimAllWhitespace(propertyValue));
        return !propertyProfiles.equals(profiles);
    }

    private List<String> expandProfiles(List<String> profiles) {
        ArrayDeque stack = new ArrayDeque();
        this.asReversedList(profiles).forEach(stack::push);
        LinkedHashSet<String> expandedProfiles = new LinkedHashSet<String>();
        while (!stack.isEmpty()) {
            String current = (String)stack.pop();
            if (!expandedProfiles.add(current)) continue;
            this.asReversedList((List)this.groups.get(current)).forEach(stack::push);
        }
        return this.asUniqueItemList(StringUtils.toStringArray(expandedProfiles));
    }

    private List<String> asReversedList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<String> reversed = new ArrayList<String>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    private List<String> asUniqueItemList(String[] array) {
        return this.asUniqueItemList(array, null);
    }

    private List<String> asUniqueItemList(String[] array, Collection<String> additional) {
        LinkedHashSet<String> uniqueItems = new LinkedHashSet<String>(Arrays.asList(array));
        if (!CollectionUtils.isEmpty(additional)) {
            uniqueItems.addAll(additional);
        }
        return Collections.unmodifiableList(new ArrayList<String>(uniqueItems));
    }

    @Override
    public Iterator<String> iterator() {
        return this.getAccepted().iterator();
    }

    public List<String> getActive() {
        return this.activeProfiles;
    }

    public List<String> getDefault() {
        return this.defaultProfiles;
    }

    public List<String> getAccepted() {
        return !this.activeProfiles.isEmpty() ? this.activeProfiles : this.defaultProfiles;
    }

    public boolean isAccepted(String profile2) {
        return this.getAccepted().contains(profile2);
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("active", this.getActive().toString());
        creator.append("default", this.getDefault().toString());
        creator.append("accepted", this.getAccepted().toString());
        return creator.toString();
    }
}

