/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper.launcher;

import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import io.mongock.cli.wrapper.launcher.LauncherCliJar;
import io.mongock.cli.wrapper.util.ClassLoaderUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class LauncherDefault
implements LauncherCliJar {
    private static final CliLogger logger = CliLoggerFactory.getLogger(LauncherDefault.class);
    private final String cliJarPath;
    private final String mongockCoreJarFile;
    private URLClassLoader classLoader;

    public LauncherDefault(String mongockCoreJarFile, String cliJarPath) {
        this.mongockCoreJarFile = mongockCoreJarFile;
        this.cliJarPath = cliJarPath;
    }

    @Override
    public LauncherCliJar loadClasses() {
        try {
            this.classLoader = this.buildClassLoader();
            ClassLoaderUtil.loadJarClasses(new JarFile(this.mongockCoreJarFile), this.classLoader);
            ClassLoaderUtil.loadJarClasses(new JarFile(this.cliJarPath), this.classLoader);
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void launch(String[] args) {
        try {
            logger.info("launching Mongock CLI runner with default launcher", new Object[0]);
            Object commandLine = this.buildCli(this.getCliBuilder());
            StringBuilder sb = new StringBuilder();
            Stream.of(args).forEach(s -> sb.append((String)s).append(" "));
            logger.debug("executing CommandLine with args: " + sb, new Object[0]);
            Method executeMethod = commandLine.getClass().getDeclaredMethod("execute", String[].class);
            executeMethod.setAccessible(true);
            executeMethod.invoke(commandLine, new Object[]{args});
            logger.debug("successful call to commandLine.execute()", new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object buildCli(Object cliBuilder) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.debug("building CommandLine", new Object[0]);
        Method buildMethod = cliBuilder.getClass().getDeclaredMethod("build", new Class[0]);
        buildMethod.setAccessible(true);
        Object commandLine = buildMethod.invoke(cliBuilder, new Object[0]);
        logger.debug("successful built commandLine " + commandLine, new Object[0]);
        return commandLine;
    }

    private Object getCliBuilder() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.debug("loading MongockCLI class", new Object[0]);
        Class<?> mongockCliClass = Class.forName("io.mongock.cli.core.CliCoreRunner", false, this.classLoader);
        logger.debug("successfully loaded MongockCLI class", new Object[0]);
        logger.debug("obtaining builder setter", new Object[0]);
        Method builderMethod = mongockCliClass.getDeclaredMethod("builder", new Class[0]);
        builderMethod.setAccessible(true);
        Object cliBuilder = builderMethod.invoke(null, new Object[0]);
        logger.debug("obtained cliBuilder", new Object[0]);
        return cliBuilder;
    }

    private URLClassLoader buildClassLoader() throws MalformedURLException {
        return URLClassLoader.newInstance(new URL[]{new URL(String.format("jar:file:%s!/", this.mongockCoreJarFile)), new URL(String.format("jar:file:%s!/", this.cliJarPath))}, Thread.currentThread().getContextClassLoader());
    }
}

