/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.core.commands.undo;

import io.mongock.cli.core.VersionProvider;
import io.mongock.cli.core.commands.CommandBase;
import io.mongock.cli.core.commands.ProfessionalOperationProxy;
import io.mongock.runner.core.builder.RunnerBuilder;
import io.mongock.runner.core.executor.MongockRunner;
import picocli.CommandLine;

@CommandLine.Command(name="undo", description={""}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class UndoCommand
extends CommandBase<Integer> {
    private static final String SUBCOMMAND_ALL = "all";
    private static final String SUBCOMMAND_UP_TO_CHANGE = "up-to-change";

    public UndoCommand(RunnerBuilder builder) {
        super(builder);
    }

    @Override
    public Integer execution() throws Exception {
        this.printUsage();
        return 2;
    }

    @CommandLine.Command(name="all", description={"(pro) - Reverts all the applied changeUnits (./mongock undo all -h for more details)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
    public Integer all() {
        MongockRunner mongockRunner = this.builder.buildRunner(ProfessionalOperationProxy.undoAllOperation());
        mongockRunner.forceEnable();
        mongockRunner.execute();
        return 0;
    }

    @CommandLine.Command(name="up-to-change", description={"(pro) - Reverts the applied migration up to specified changeUnitId (./mongock undo up-to-change -h for more details)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
    public Integer upToChange(@CommandLine.Parameters(index="0", description={"ChangeUnit id up to which Mongock will rollback(inclusive)."}, paramLabel="<CHANGE_UNIT_ID>") String changeUnitId) {
        MongockRunner mongockRunner = this.builder.buildRunner(ProfessionalOperationProxy.undoUpToChangeOperation(changeUnitId));
        mongockRunner.forceEnable();
        mongockRunner.execute();
        return 0;
    }
}

