/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.api.entry;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.api.util.ChangePrintable;
import io.mongock.utils.StringUtils;
import io.mongock.utils.field.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ChangeEntry
implements ChangePrintable {
    public static final String KEY_EXECUTION_ID = "executionId";
    public static final String KEY_CHANGE_ID = "changeId";
    public static final String KEY_AUTHOR = "author";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_STATE = "state";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CHANGELOG_CLASS = "changeLogClass";
    public static final String KEY_CHANGESET_METHOD = "changeSetMethod";
    public static final String KEY_METADATA = "metadata";
    public static final String KEY_EXECUTION_MILLIS = "executionMillis";
    public static final String KEY_EXECUTION_HOST_NAME = "executionHostname";
    public static final String KEY_ERROR_TRACE = "errorTrace";
    @Field(value="executionId", type=Field.KeyType.PRIMARY)
    protected String executionId;
    @Field(value="changeId", type=Field.KeyType.PRIMARY)
    protected String changeId;
    @Field(value="author", type=Field.KeyType.PRIMARY)
    protected String author;
    @Field(value="timestamp")
    protected Date timestamp;
    @Field(value="state")
    protected ChangeState state;
    @Field(value="type")
    protected ChangeType type;
    @Field(value="changeLogClass")
    protected String changeLogClass;
    @Field(value="changeSetMethod")
    protected String changeSetMethod;
    @Field(value="metadata")
    protected Object metadata;
    @Field(value="executionMillis")
    protected long executionMillis;
    @Field(value="executionHostname")
    protected String executionHostname;
    @Field(value="errorTrace")
    protected String errorTrace;
    protected Date originalTimestamp;
    private static final Set<ChangeState> RELEVANT_STATES = Collections.unmodifiableSet(new HashSet<ChangeState>(Arrays.asList(ChangeState.EXECUTED, ChangeState.ROLLED_BACK, ChangeState.FAILED, ChangeState.ROLLBACK_FAILED)));

    public ChangeEntry() {
    }

    public ChangeEntry(String executionId, String changeId, String author, Date timestamp, ChangeState state, ChangeType type, String changeLogClass, String changeSetMethod, long executionMillis, String executionHostname, Object metadata) {
        this(executionId, changeId, author, timestamp, state, type, changeLogClass, changeSetMethod, executionMillis, executionHostname, metadata, null);
    }

    public ChangeEntry(String executionId, String changeId, String author, Date timestamp, ChangeState state, ChangeType type, String changeLogClass, String changeSetMethod, long executionMillis, String executionHostname, Object metadata, String errorTrace) {
        this.executionId = executionId;
        this.changeId = changeId;
        this.author = author;
        this.timestamp = new Date(timestamp.getTime());
        this.state = state != null ? state : ChangeState.EXECUTED;
        this.type = type != null ? type : ChangeType.EXECUTION;
        this.changeLogClass = changeLogClass;
        this.changeSetMethod = changeSetMethod;
        this.executionMillis = executionMillis;
        this.executionHostname = executionHostname;
        this.metadata = metadata;
        this.errorTrace = errorTrace;
        this.originalTimestamp = null;
    }

    public static ChangeEntry instance(String executionId, String author, ChangeState state, ChangeType type, String changeSetId, String changeSetClassName, String changeSetName, long executionMillis, String executionHostname, Object metadata) {
        return new ChangeEntry(executionId, changeSetId, author, new Date(), state, type, changeSetClassName, changeSetName, executionMillis, executionHostname, metadata);
    }

    public static ChangeEntry failedInstance(String executionId, String author, ChangeState state, ChangeType type, String changeSetId, String changeSetClassName, String changeSetName, long executionMillis, String executionHostname, Object metadata, String error) {
        if (!state.isFailed()) {
            throw new MongockException("Creating a failed instance of changeEntry with a non-failed stated: " + state.name());
        }
        return new ChangeEntry(executionId, changeSetId, author, new Date(), state, type, changeSetClassName, changeSetName, executionMillis, executionHostname, metadata, error);
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getChangeId() {
        return this.changeId;
    }

    @Override
    public String getId() {
        return this.getChangeId();
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getChangeLogClassString() {
        return StringUtils.getSimpleClassName((String)this.changeLogClass);
    }

    @Override
    public String getMethodNameString() {
        return this.getChangeSetMethod();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ChangeState getState() {
        return this.state;
    }

    public String getChangeLogClass() {
        return this.changeLogClass;
    }

    public String getChangeSetMethod() {
        return this.changeSetMethod;
    }

    public long getExecutionMillis() {
        return this.executionMillis;
    }

    public String getExecutionHostname() {
        return this.executionHostname;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public ChangeType getType() {
        return this.type;
    }

    public Optional<String> getErrorTrace() {
        return Optional.ofNullable(this.errorTrace);
    }

    public Date getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    public void setOriginalTimestamp(Date originalTimestamp) {
        this.originalTimestamp = originalTimestamp;
    }

    public String toString() {
        return "ChangeEntry{executionId='" + this.executionId + '\'' + ", changeId='" + this.changeId + '\'' + ", author='" + this.author + '\'' + ", timestamp=" + this.timestamp + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", changeLogClass='" + this.changeLogClass + '\'' + ", changeSetMethod='" + this.changeSetMethod + '\'' + ", metadata=" + this.metadata + ", executionMillis=" + this.executionMillis + ", executionHostname='" + this.executionHostname + '\'' + '}';
    }

    public boolean hasRelevantState() {
        return this.state == null || RELEVANT_STATES.contains((Object)this.state);
    }

    public boolean isExecuted() {
        return this.state == null || ChangeState.EXECUTED == this.state;
    }
}

