/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper;

import io.mongock.cli.util.banner.Banner;
import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import io.mongock.cli.wrapper.launcher.LauncherCliJar;
import io.mongock.cli.wrapper.util.ArgsUtil;
import java.util.stream.Stream;

public class MongockCli {
    private static final CliLogger logger = CliLoggerFactory.getLogger(MongockCli.class);
    private static final String[] argumentsToCleanUp = new String[]{"--app-jar", "-aj", "--cli-spring-jar", "--cli-core-jar", "--log-level", "--mongock-core-jar"};

    public static void main(String ... args) {
        MongockCli.setLogger(args);
        MongockCli.printArgs(args);
        try {
            String appJar = ArgsUtil.getOptionalParam(args, "--app-jar").orElseGet(() -> ArgsUtil.getParameter(args, "-aj", false));
            LauncherCliJar.builder().setAppJarFile(appJar).setCliCoreJar(ArgsUtil.getParameter(args, "--cli-core-jar", false)).setCliSpringJar(ArgsUtil.getParameter(args, "--cli-spring-jar", false)).setMongockCoreJarFile(ArgsUtil.getParameter(args, "--mongock-core-jar", false)).build().loadClasses().launch(ArgsUtil.getCleanArgs(args, argumentsToCleanUp));
            System.exit(0);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        StringBuilder sb = new StringBuilder("CLI arguments: ");
        Stream.of(args).forEach(arg -> sb.append((String)arg).append(" "));
        logger.debug(sb.toString(), new Object[0]);
    }

    private static void setLogger(String[] args) {
        CliLoggerFactory.setLevel(ArgsUtil.getOptionalParam(args, "--log-level").map(CliLogger.Level::fromStringDefaultInfo).orElse(CliLogger.Level.INFO));
    }

    static {
        Banner.print(System.out);
    }
}

